package com.google.cloud.pubsublite.internal;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.proto.CursorServiceGrpc;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CursorClientSettings extends CursorClientSettings {

  private final CloudRegion region;

  private final RetrySettings retrySettings;

  private final Optional<CursorServiceGrpc.CursorServiceBlockingStub> stub;

  private AutoValue_CursorClientSettings(
      CloudRegion region,
      RetrySettings retrySettings,
      Optional<CursorServiceGrpc.CursorServiceBlockingStub> stub) {
    this.region = region;
    this.retrySettings = retrySettings;
    this.stub = stub;
  }

  @Override
  CloudRegion region() {
    return region;
  }

  @Override
  RetrySettings retrySettings() {
    return retrySettings;
  }

  @Override
  Optional<CursorServiceGrpc.CursorServiceBlockingStub> stub() {
    return stub;
  }

  @Override
  public String toString() {
    return "CursorClientSettings{"
        + "region=" + region + ", "
        + "retrySettings=" + retrySettings + ", "
        + "stub=" + stub
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CursorClientSettings) {
      CursorClientSettings that = (CursorClientSettings) o;
      return this.region.equals(that.region())
          && this.retrySettings.equals(that.retrySettings())
          && this.stub.equals(that.stub());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= region.hashCode();
    h$ *= 1000003;
    h$ ^= retrySettings.hashCode();
    h$ *= 1000003;
    h$ ^= stub.hashCode();
    return h$;
  }

  static final class Builder extends CursorClientSettings.Builder {
    private CloudRegion region;
    private RetrySettings retrySettings;
    private Optional<CursorServiceGrpc.CursorServiceBlockingStub> stub = Optional.empty();
    Builder() {
    }
    @Override
    public CursorClientSettings.Builder setRegion(CloudRegion region) {
      if (region == null) {
        throw new NullPointerException("Null region");
      }
      this.region = region;
      return this;
    }
    @Override
    public CursorClientSettings.Builder setRetrySettings(RetrySettings retrySettings) {
      if (retrySettings == null) {
        throw new NullPointerException("Null retrySettings");
      }
      this.retrySettings = retrySettings;
      return this;
    }
    @Override
    public CursorClientSettings.Builder setStub(CursorServiceGrpc.CursorServiceBlockingStub stub) {
      this.stub = Optional.of(stub);
      return this;
    }
    @Override
    public CursorClientSettings build() {
      String missing = "";
      if (this.region == null) {
        missing += " region";
      }
      if (this.retrySettings == null) {
        missing += " retrySettings";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CursorClientSettings(
          this.region,
          this.retrySettings,
          this.stub);
    }
  }

}
