/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AutoValue_AdminClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Constants;
import com.google.cloud.pubsublite.Stubs;
import com.google.cloud.pubsublite.internal.AdminClientImpl;
import com.google.cloud.pubsublite.proto.AdminServiceGrpc;
import io.grpc.StatusException;
import java.util.Optional;

@AutoValue
public abstract class AdminClientSettings {
    abstract CloudRegion region();

    abstract RetrySettings retrySettings();

    abstract Optional<AdminServiceGrpc.AdminServiceBlockingStub> stub();

    public static Builder newBuilder() {
        return new AutoValue_AdminClientSettings.Builder().setRetrySettings(Constants.DEFAULT_RETRY_SETTINGS);
    }

    AdminClient instantiate() throws StatusException {
        AdminServiceGrpc.AdminServiceBlockingStub stub = this.stub().isPresent() ? this.stub().get() : Stubs.defaultStub(this.region(), AdminServiceGrpc::newBlockingStub);
        return new AdminClientImpl(this.region(), stub, this.retrySettings());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRegion(CloudRegion var1);

        public abstract Builder setRetrySettings(RetrySettings var1);

        public abstract Builder setStub(AdminServiceGrpc.AdminServiceBlockingStub var1);

        public abstract AdminClientSettings build();
    }
}

