/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.proto.AdminServiceGrpc;
import java.util.Optional;

final class AutoValue_AdminClientSettings
extends AdminClientSettings {
    private final CloudRegion region;
    private final RetrySettings retrySettings;
    private final Optional<AdminServiceGrpc.AdminServiceBlockingStub> stub;

    private AutoValue_AdminClientSettings(CloudRegion region, RetrySettings retrySettings, Optional<AdminServiceGrpc.AdminServiceBlockingStub> stub) {
        this.region = region;
        this.retrySettings = retrySettings;
        this.stub = stub;
    }

    @Override
    CloudRegion region() {
        return this.region;
    }

    @Override
    RetrySettings retrySettings() {
        return this.retrySettings;
    }

    @Override
    Optional<AdminServiceGrpc.AdminServiceBlockingStub> stub() {
        return this.stub;
    }

    public String toString() {
        return "AdminClientSettings{region=" + this.region + ", retrySettings=" + this.retrySettings + ", stub=" + this.stub + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdminClientSettings) {
            AdminClientSettings that = (AdminClientSettings)o;
            return this.region.equals(that.region()) && this.retrySettings.equals(that.retrySettings()) && this.stub.equals(that.stub());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.region.hashCode();
        h$ *= 1000003;
        h$ ^= this.retrySettings.hashCode();
        h$ *= 1000003;
        return h$ ^= this.stub.hashCode();
    }

    static final class Builder
    extends AdminClientSettings.Builder {
        private CloudRegion region;
        private RetrySettings retrySettings;
        private Optional<AdminServiceGrpc.AdminServiceBlockingStub> stub = Optional.empty();

        Builder() {
        }

        @Override
        public AdminClientSettings.Builder setRegion(CloudRegion region) {
            if (region == null) {
                throw new NullPointerException("Null region");
            }
            this.region = region;
            return this;
        }

        @Override
        public AdminClientSettings.Builder setRetrySettings(RetrySettings retrySettings) {
            if (retrySettings == null) {
                throw new NullPointerException("Null retrySettings");
            }
            this.retrySettings = retrySettings;
            return this;
        }

        @Override
        public AdminClientSettings.Builder setStub(AdminServiceGrpc.AdminServiceBlockingStub stub) {
            this.stub = Optional.of(stub);
            return this;
        }

        @Override
        public AdminClientSettings build() {
            String missing = "";
            if (this.region == null) {
                missing = missing + " region";
            }
            if (this.retrySettings == null) {
                missing = missing + " retrySettings";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AdminClientSettings(this.region, this.retrySettings, this.stub);
        }
    }
}

