/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AutoValue_LocationPath;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.ProjectBuilderHelper;
import com.google.cloud.pubsublite.ProjectIdOrNumber;
import com.google.cloud.pubsublite.ProjectPath;
import com.google.cloud.pubsublite.internal.Preconditions;
import io.grpc.StatusException;
import java.io.Serializable;
import java.util.Arrays;

@AutoValue
public abstract class LocationPath
implements Serializable {
    public abstract ProjectIdOrNumber project();

    public abstract CloudZone location();

    public ProjectPath projectPath() {
        return ((ProjectPath.Builder)ProjectPath.newBuilder().setProject(this.project())).build();
    }

    public String toString() {
        return this.projectPath() + "/locations/" + this.location();
    }

    public static Builder newBuilder() {
        return new AutoValue_LocationPath.Builder();
    }

    public abstract Builder toBuilder();

    public static LocationPath parse(String path) throws StatusException {
        String[] splits = path.split("/");
        Preconditions.checkArgument(splits.length == 4);
        Preconditions.checkArgument(splits[2].equals("locations"));
        ProjectPath project = ProjectPath.parse(String.join((CharSequence)"/", Arrays.copyOf(splits, 2)));
        return ((Builder)LocationPath.newBuilder().setProject(project.project())).setLocation(CloudZone.parse(splits[3])).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends ProjectBuilderHelper<Builder> {
        public abstract Builder setLocation(CloudZone var1);

        public abstract LocationPath build();
    }
}

