/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.ProjectId;
import com.google.cloud.pubsublite.ProjectIdOrNumber;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.ProjectPath;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.resourcemanager.Project;
import com.google.cloud.resourcemanager.ResourceManager;
import com.google.cloud.resourcemanager.ResourceManagerOptions;
import io.grpc.StatusException;

public final class ProjectLookupUtils {
    private static ResourceManager resourceManager = null;

    private ProjectLookupUtils() {
    }

    private static synchronized ResourceManager getResourceManager() {
        if (resourceManager == null) {
            resourceManager = (ResourceManager)ResourceManagerOptions.getDefaultInstance().getService();
        }
        return resourceManager;
    }

    private static ProjectNumber getProjectNumber(ProjectId id) throws StatusException {
        try {
            Project project = ProjectLookupUtils.getResourceManager().get(id.toString(), new ResourceManager.ProjectGetOption[0]);
            return ProjectNumber.of(project.getProjectNumber());
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical(t);
        }
    }

    static ProjectNumber toCanonical(ProjectIdOrNumber project) throws StatusException {
        if (project.getKind() == ProjectIdOrNumber.Kind.NUMBER) {
            return project.number();
        }
        return ProjectLookupUtils.getProjectNumber(project.name());
    }

    public static ProjectPath toCanonical(ProjectPath path) throws StatusException {
        return ((ProjectPath.Builder)path.toBuilder().setProject(ProjectLookupUtils.toCanonical(path.project()))).build();
    }

    public static LocationPath toCanonical(LocationPath path) throws StatusException {
        return ((LocationPath.Builder)path.toBuilder().setProject(ProjectLookupUtils.toCanonical(path.project()))).build();
    }

    public static SubscriptionPath toCanonical(SubscriptionPath path) throws StatusException {
        return ((SubscriptionPath.Builder)path.toBuilder().setProject(ProjectLookupUtils.toCanonical(path.project()))).build();
    }

    public static TopicPath toCanonical(TopicPath path) throws StatusException {
        return ((TopicPath.Builder)path.toBuilder().setProject(ProjectLookupUtils.toCanonical(path.project()))).build();
    }
}

