/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Endpoints;
import com.google.cloud.pubsublite.internal.ChannelCache;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.common.collect.ImmutableList;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.StatusException;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.stub.AbstractStub;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Stubs {
    private static final ChannelCache channels = new ChannelCache();

    public static <StubT extends AbstractStub<StubT>> StubT defaultStub(CloudRegion target, Function<Channel, StubT> stubFactory) throws StatusException {
        return Stubs.defaultStub(Endpoints.regionalEndpoint(target), stubFactory);
    }

    public static <StubT extends AbstractStub<StubT>> StubT defaultStub(String target, Function<Channel, StubT> stubFactory) throws StatusException {
        try {
            return (StubT)((AbstractStub)stubFactory.apply(ClientInterceptors.intercept((Channel)channels.get(target), Stubs.getClientInterceptors()))).withCallCredentials(MoreCallCredentials.from((Credentials)GoogleCredentials.getApplicationDefault().createScoped((Collection)ImmutableList.of((Object)"https://www.googleapis.com/auth/cloud-platform"))));
        }
        catch (IOException e) {
            throw ExtractStatus.toCanonical(e);
        }
    }

    private static List<ClientInterceptor> getClientInterceptors() {
        ArrayList<ClientInterceptor> clientInterceptors = new ArrayList<ClientInterceptor>();
        final Map apiClientHeaders = ApiClientHeaderProvider.newBuilder().setClientLibToken("gccl", GaxProperties.getLibraryVersion(Stubs.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion()).build().getHeaders();
        clientInterceptors.add(new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                ClientCall call = next.newCall(method, callOptions);
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        for (Map.Entry apiClientHeader : apiClientHeaders.entrySet()) {
                            headers.put(Metadata.Key.of((String)((String)apiClientHeader.getKey()), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), apiClientHeader.getValue());
                        }
                        super.start(responseListener, headers);
                    }
                };
            }
        });
        return clientInterceptors;
    }

    private Stubs() {
    }
}

