/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.cloudpubsub.NackHandler;
import com.google.cloud.pubsublite.cloudpubsub.SubscriberSettings;
import com.google.cloud.pubsublite.proto.CursorServiceGrpc;
import com.google.cloud.pubsublite.proto.PartitionAssignmentServiceGrpc;
import com.google.cloud.pubsublite.proto.SubscriberServiceGrpc;
import com.google.pubsub.v1.PubsubMessage;
import java.util.List;
import java.util.Optional;

final class AutoValue_SubscriberSettings
extends SubscriberSettings {
    private final MessageReceiver receiver;
    private final SubscriptionPath subscriptionPath;
    private final FlowControlSettings perPartitionFlowControlSettings;
    private final Optional<List<Partition>> partitions;
    private final Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer;
    private final Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub;
    private final Optional<CursorServiceGrpc.CursorServiceStub> cursorServiceStub;
    private final Optional<PartitionAssignmentServiceGrpc.PartitionAssignmentServiceStub> assignmentServiceStub;
    private final Optional<NackHandler> nackHandler;

    private AutoValue_SubscriberSettings(MessageReceiver receiver, SubscriptionPath subscriptionPath, FlowControlSettings perPartitionFlowControlSettings, Optional<List<Partition>> partitions, Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer, Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub, Optional<CursorServiceGrpc.CursorServiceStub> cursorServiceStub, Optional<PartitionAssignmentServiceGrpc.PartitionAssignmentServiceStub> assignmentServiceStub, Optional<NackHandler> nackHandler) {
        this.receiver = receiver;
        this.subscriptionPath = subscriptionPath;
        this.perPartitionFlowControlSettings = perPartitionFlowControlSettings;
        this.partitions = partitions;
        this.transformer = transformer;
        this.subscriberServiceStub = subscriberServiceStub;
        this.cursorServiceStub = cursorServiceStub;
        this.assignmentServiceStub = assignmentServiceStub;
        this.nackHandler = nackHandler;
    }

    @Override
    MessageReceiver receiver() {
        return this.receiver;
    }

    @Override
    SubscriptionPath subscriptionPath() {
        return this.subscriptionPath;
    }

    @Override
    FlowControlSettings perPartitionFlowControlSettings() {
        return this.perPartitionFlowControlSettings;
    }

    @Override
    Optional<List<Partition>> partitions() {
        return this.partitions;
    }

    @Override
    Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer() {
        return this.transformer;
    }

    @Override
    Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub() {
        return this.subscriberServiceStub;
    }

    @Override
    Optional<CursorServiceGrpc.CursorServiceStub> cursorServiceStub() {
        return this.cursorServiceStub;
    }

    @Override
    Optional<PartitionAssignmentServiceGrpc.PartitionAssignmentServiceStub> assignmentServiceStub() {
        return this.assignmentServiceStub;
    }

    @Override
    Optional<NackHandler> nackHandler() {
        return this.nackHandler;
    }

    public String toString() {
        return "SubscriberSettings{receiver=" + this.receiver + ", subscriptionPath=" + this.subscriptionPath + ", perPartitionFlowControlSettings=" + this.perPartitionFlowControlSettings + ", partitions=" + this.partitions + ", transformer=" + this.transformer + ", subscriberServiceStub=" + this.subscriberServiceStub + ", cursorServiceStub=" + this.cursorServiceStub + ", assignmentServiceStub=" + this.assignmentServiceStub + ", nackHandler=" + this.nackHandler + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubscriberSettings) {
            SubscriberSettings that = (SubscriberSettings)o;
            return this.receiver.equals(that.receiver()) && this.subscriptionPath.equals(that.subscriptionPath()) && this.perPartitionFlowControlSettings.equals(that.perPartitionFlowControlSettings()) && this.partitions.equals(that.partitions()) && this.transformer.equals(that.transformer()) && this.subscriberServiceStub.equals(that.subscriberServiceStub()) && this.cursorServiceStub.equals(that.cursorServiceStub()) && this.assignmentServiceStub.equals(that.assignmentServiceStub()) && this.nackHandler.equals(that.nackHandler());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.receiver.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscriptionPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.perPartitionFlowControlSettings.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.transformer.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscriberServiceStub.hashCode();
        h$ *= 1000003;
        h$ ^= this.cursorServiceStub.hashCode();
        h$ *= 1000003;
        h$ ^= this.assignmentServiceStub.hashCode();
        h$ *= 1000003;
        return h$ ^= this.nackHandler.hashCode();
    }

    static final class Builder
    extends SubscriberSettings.Builder {
        private MessageReceiver receiver;
        private SubscriptionPath subscriptionPath;
        private FlowControlSettings perPartitionFlowControlSettings;
        private Optional<List<Partition>> partitions = Optional.empty();
        private Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer = Optional.empty();
        private Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub = Optional.empty();
        private Optional<CursorServiceGrpc.CursorServiceStub> cursorServiceStub = Optional.empty();
        private Optional<PartitionAssignmentServiceGrpc.PartitionAssignmentServiceStub> assignmentServiceStub = Optional.empty();
        private Optional<NackHandler> nackHandler = Optional.empty();

        Builder() {
        }

        @Override
        public SubscriberSettings.Builder setReceiver(MessageReceiver receiver) {
            if (receiver == null) {
                throw new NullPointerException("Null receiver");
            }
            this.receiver = receiver;
            return this;
        }

        @Override
        public SubscriberSettings.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
            if (subscriptionPath == null) {
                throw new NullPointerException("Null subscriptionPath");
            }
            this.subscriptionPath = subscriptionPath;
            return this;
        }

        @Override
        public SubscriberSettings.Builder setPerPartitionFlowControlSettings(FlowControlSettings perPartitionFlowControlSettings) {
            if (perPartitionFlowControlSettings == null) {
                throw new NullPointerException("Null perPartitionFlowControlSettings");
            }
            this.perPartitionFlowControlSettings = perPartitionFlowControlSettings;
            return this;
        }

        @Override
        public SubscriberSettings.Builder setPartitions(List<Partition> partitions) {
            this.partitions = Optional.of(partitions);
            return this;
        }

        @Override
        public SubscriberSettings.Builder setTransformer(MessageTransformer<SequencedMessage, PubsubMessage> transformer) {
            this.transformer = Optional.of(transformer);
            return this;
        }

        @Override
        public SubscriberSettings.Builder setSubscriberServiceStub(SubscriberServiceGrpc.SubscriberServiceStub subscriberServiceStub) {
            this.subscriberServiceStub = Optional.of(subscriberServiceStub);
            return this;
        }

        @Override
        public SubscriberSettings.Builder setCursorServiceStub(CursorServiceGrpc.CursorServiceStub cursorServiceStub) {
            this.cursorServiceStub = Optional.of(cursorServiceStub);
            return this;
        }

        @Override
        public SubscriberSettings.Builder setAssignmentServiceStub(PartitionAssignmentServiceGrpc.PartitionAssignmentServiceStub assignmentServiceStub) {
            this.assignmentServiceStub = Optional.of(assignmentServiceStub);
            return this;
        }

        @Override
        public SubscriberSettings.Builder setNackHandler(NackHandler nackHandler) {
            this.nackHandler = Optional.of(nackHandler);
            return this;
        }

        @Override
        SubscriberSettings autoBuild() {
            String missing = "";
            if (this.receiver == null) {
                missing = missing + " receiver";
            }
            if (this.subscriptionPath == null) {
                missing = missing + " subscriptionPath";
            }
            if (this.perPartitionFlowControlSettings == null) {
                missing = missing + " perPartitionFlowControlSettings";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SubscriberSettings(this.receiver, this.subscriptionPath, this.perPartitionFlowControlSettings, this.partitions, this.transformer, this.subscriberServiceStub, this.cursorServiceStub, this.assignmentServiceStub, this.nackHandler);
        }
    }
}

