/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectLookupUtils;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.AutoValue_SubscriberSettings;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.cloudpubsub.MessageTransforms;
import com.google.cloud.pubsublite.cloudpubsub.NackHandler;
import com.google.cloud.pubsublite.cloudpubsub.Subscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.AckSetTrackerImpl;
import com.google.cloud.pubsublite.cloudpubsub.internal.AssigningSubscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.MultiPartitionSubscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.PartitionSubscriberFactory;
import com.google.cloud.pubsublite.cloudpubsub.internal.SinglePartitionSubscriber;
import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.cloud.pubsublite.internal.wire.AssignerBuilder;
import com.google.cloud.pubsublite.internal.wire.AssignerFactory;
import com.google.cloud.pubsublite.internal.wire.CommitterBuilder;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.proto.CursorServiceGrpc;
import com.google.cloud.pubsublite.proto.PartitionAssignmentServiceGrpc;
import com.google.cloud.pubsublite.proto.SubscriberServiceGrpc;
import com.google.pubsub.v1.PubsubMessage;
import io.grpc.StatusException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@AutoValue
public abstract class SubscriberSettings {
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of("CLOUD_PUBSUB_SHIM");

    abstract MessageReceiver receiver();

    abstract SubscriptionPath subscriptionPath();

    abstract FlowControlSettings perPartitionFlowControlSettings();

    abstract Optional<List<Partition>> partitions();

    abstract Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer();

    abstract Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub();

    abstract Optional<CursorServiceGrpc.CursorServiceStub> cursorServiceStub();

    abstract Optional<PartitionAssignmentServiceGrpc.PartitionAssignmentServiceStub> assignmentServiceStub();

    abstract Optional<NackHandler> nackHandler();

    public static Builder newBuilder() {
        return new AutoValue_SubscriberSettings.Builder();
    }

    Subscriber instantiate() throws StatusException {
        SubscriptionPath canonicalPath = ProjectLookupUtils.toCanonical(this.subscriptionPath());
        SubscriberBuilder.Builder wireSubscriberBuilder = SubscriberBuilder.newBuilder();
        wireSubscriberBuilder.setSubscriptionPath(canonicalPath);
        this.subscriberServiceStub().ifPresent(wireSubscriberBuilder::setSubscriberServiceStub);
        wireSubscriberBuilder.setContext(PubsubContext.of(FRAMEWORK));
        CommitterBuilder.Builder wireCommitterBuilder = CommitterBuilder.newBuilder();
        wireCommitterBuilder.setSubscriptionPath(canonicalPath);
        this.cursorServiceStub().ifPresent(wireCommitterBuilder::setCursorStub);
        PartitionSubscriberFactory partitionSubscriberFactory = partition -> {
            wireSubscriberBuilder.setPartition(partition);
            wireCommitterBuilder.setPartition(partition);
            return new SinglePartitionSubscriber(this.receiver(), this.transformer().orElse(MessageTransforms.toCpsSubscribeTransformer()), new AckSetTrackerImpl(wireCommitterBuilder.build()), this.nackHandler().orElse(new NackHandler(){}), messageConsumer -> wireSubscriberBuilder.setMessageConsumer(messageConsumer).build(), this.perPartitionFlowControlSettings());
        };
        if (!this.partitions().isPresent()) {
            AssignerBuilder.Builder assignerBuilder = AssignerBuilder.newBuilder();
            assignerBuilder.setSubscriptionPath(canonicalPath);
            this.assignmentServiceStub().ifPresent(assignerBuilder::setAssignmentStub);
            AssignerFactory assignerFactory = receiver -> {
                assignerBuilder.setReceiver(receiver);
                return assignerBuilder.build();
            };
            return new AssigningSubscriber(partitionSubscriberFactory, assignerFactory);
        }
        ArrayList<Subscriber> perPartitionSubscribers = new ArrayList<Subscriber>();
        for (Partition partition2 : this.partitions().get()) {
            wireSubscriberBuilder.setPartition(partition2);
            wireCommitterBuilder.setPartition(partition2);
            perPartitionSubscribers.add(partitionSubscriberFactory.New(partition2));
        }
        return MultiPartitionSubscriber.of(perPartitionSubscribers);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setReceiver(MessageReceiver var1);

        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPerPartitionFlowControlSettings(FlowControlSettings var1);

        public abstract Builder setPartitions(List<Partition> var1);

        public abstract Builder setTransformer(MessageTransformer<SequencedMessage, PubsubMessage> var1);

        public abstract Builder setSubscriberServiceStub(SubscriberServiceGrpc.SubscriberServiceStub var1);

        public abstract Builder setCursorServiceStub(CursorServiceGrpc.CursorServiceStub var1);

        public abstract Builder setAssignmentServiceStub(PartitionAssignmentServiceGrpc.PartitionAssignmentServiceStub var1);

        public abstract Builder setNackHandler(NackHandler var1);

        abstract SubscriberSettings autoBuild();

        public SubscriberSettings build() throws StatusException {
            SubscriberSettings settings = this.autoBuild();
            Preconditions.checkArgument(!settings.partitions().isPresent() || !settings.partitions().get().isEmpty(), "Must provide at least one partition if setting partitions explicitly.");
            return settings;
        }
    }
}

