/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.ProjectLookupUtils;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ApiResourceAggregation;
import com.google.cloud.pubsublite.internal.RetryingExecutorUtil;
import com.google.cloud.pubsublite.proto.AdminServiceGrpc;
import com.google.cloud.pubsublite.proto.CreateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.CreateTopicRequest;
import com.google.cloud.pubsublite.proto.DeleteSubscriptionRequest;
import com.google.cloud.pubsublite.proto.DeleteTopicRequest;
import com.google.cloud.pubsublite.proto.GetSubscriptionRequest;
import com.google.cloud.pubsublite.proto.GetTopicPartitionsRequest;
import com.google.cloud.pubsublite.proto.GetTopicRequest;
import com.google.cloud.pubsublite.proto.ListSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListTopicsRequest;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.proto.Topic;
import com.google.cloud.pubsublite.proto.UpdateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.UpdateTopicRequest;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.FieldMask;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class AdminClientImpl
extends ApiResourceAggregation
implements AdminClient {
    private final CloudRegion region;
    private final AdminServiceGrpc.AdminServiceBlockingStub stub;
    private final RetryingExecutor<Void> voidRetryingExecutor;
    private final RetryingExecutor<Topic> topicRetryingExecutor;
    private final RetryingExecutor<Subscription> subscriptionRetryingExecutor;
    private final RetryingExecutor<Long> partitionCountRetryingExecutor;
    private final RetryingExecutor<List<Topic>> listTopicsRetryingExecutor;
    private final RetryingExecutor<List<SubscriptionPath>> listTopicSubscriptionsRetryingExecutor;
    private final RetryingExecutor<List<Subscription>> listSubscriptionsRetryingExecutor;

    public AdminClientImpl(CloudRegion region, AdminServiceGrpc.AdminServiceBlockingStub stub, RetrySettings retrySettings) {
        this(region, stub, retrySettings, Executors.newScheduledThreadPool(6));
    }

    private AdminClientImpl(CloudRegion region, AdminServiceGrpc.AdminServiceBlockingStub stub, RetrySettings retrySettings, ScheduledExecutorService executor) {
        super(new BackgroundResource[]{new ExecutorAsBackgroundResource((ExecutorService)executor)});
        this.region = region;
        this.stub = stub;
        this.voidRetryingExecutor = RetryingExecutorUtil.retryingExecutor(retrySettings, executor);
        this.topicRetryingExecutor = RetryingExecutorUtil.retryingExecutor(retrySettings, executor);
        this.subscriptionRetryingExecutor = RetryingExecutorUtil.retryingExecutor(retrySettings, executor);
        this.partitionCountRetryingExecutor = RetryingExecutorUtil.retryingExecutor(retrySettings, executor);
        this.listTopicsRetryingExecutor = RetryingExecutorUtil.retryingExecutor(retrySettings, executor);
        this.listSubscriptionsRetryingExecutor = RetryingExecutorUtil.retryingExecutor(retrySettings, executor);
        this.listTopicSubscriptionsRetryingExecutor = RetryingExecutorUtil.retryingExecutor(retrySettings, executor);
    }

    @Override
    public CloudRegion region() {
        return this.region;
    }

    @Override
    public ApiFuture<Topic> createTopic(Topic topic) {
        return RetryingExecutorUtil.runWithRetries(() -> {
            TopicPath path = ProjectLookupUtils.toCanonical(TopicPath.parse(topic.getName()));
            return this.stub.createTopic(CreateTopicRequest.newBuilder().setParent(path.locationPath().toString()).setTopic(topic).setTopicId(path.name().value()).build());
        }, this.topicRetryingExecutor);
    }

    @Override
    public ApiFuture<Topic> getTopic(TopicPath path) {
        return RetryingExecutorUtil.runWithRetries(() -> this.stub.getTopic(GetTopicRequest.newBuilder().setName(ProjectLookupUtils.toCanonical(path).toString()).build()), this.topicRetryingExecutor);
    }

    @Override
    public ApiFuture<Long> getTopicPartitionCount(TopicPath path) {
        return RetryingExecutorUtil.runWithRetries(() -> this.stub.getTopicPartitions(GetTopicPartitionsRequest.newBuilder().setName(ProjectLookupUtils.toCanonical(path).toString()).build()).getPartitionCount(), this.partitionCountRetryingExecutor);
    }

    @Override
    public ApiFuture<List<Topic>> listTopics(LocationPath path) {
        return RetryingExecutorUtil.runWithRetries(() -> this.stub.listTopics(ListTopicsRequest.newBuilder().setParent(ProjectLookupUtils.toCanonical(path).toString()).build()).getTopicsList(), this.listTopicsRetryingExecutor);
    }

    @Override
    public ApiFuture<Topic> updateTopic(Topic topic, FieldMask mask) {
        return RetryingExecutorUtil.runWithRetries(() -> {
            Topic canonical = topic.toBuilder().setName(ProjectLookupUtils.toCanonical(TopicPath.parse(topic.getName())).toString()).build();
            return this.stub.updateTopic(UpdateTopicRequest.newBuilder().setTopic(canonical).setUpdateMask(mask).build());
        }, this.topicRetryingExecutor);
    }

    @Override
    public ApiFuture<Void> deleteTopic(TopicPath path) {
        return RetryingExecutorUtil.runWithRetries(() -> {
            this.stub.deleteTopic(DeleteTopicRequest.newBuilder().setName(ProjectLookupUtils.toCanonical(path).toString()).build());
            return null;
        }, this.voidRetryingExecutor);
    }

    @Override
    public ApiFuture<List<SubscriptionPath>> listTopicSubscriptions(TopicPath path) {
        return RetryingExecutorUtil.runWithRetries(() -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String subscription : this.stub.listTopicSubscriptions(ListTopicSubscriptionsRequest.newBuilder().setName(ProjectLookupUtils.toCanonical(path).toString()).build()).getSubscriptionsList()) {
                SubscriptionPath subscription_path = SubscriptionPath.parse(subscription);
                builder.add((Object)subscription_path);
            }
            return builder.build();
        }, this.listTopicSubscriptionsRetryingExecutor);
    }

    @Override
    public ApiFuture<Subscription> createSubscription(Subscription subscription) {
        return RetryingExecutorUtil.runWithRetries(() -> {
            SubscriptionPath path = ProjectLookupUtils.toCanonical(SubscriptionPath.parse(subscription.getName()));
            return this.stub.createSubscription(CreateSubscriptionRequest.newBuilder().setParent(path.locationPath().toString()).setSubscription(subscription).setSubscriptionId(path.name().toString()).build());
        }, this.subscriptionRetryingExecutor);
    }

    @Override
    public ApiFuture<Subscription> getSubscription(SubscriptionPath path) {
        return RetryingExecutorUtil.runWithRetries(() -> this.stub.getSubscription(GetSubscriptionRequest.newBuilder().setName(ProjectLookupUtils.toCanonical(path).toString()).build()), this.subscriptionRetryingExecutor);
    }

    @Override
    public ApiFuture<List<Subscription>> listSubscriptions(LocationPath path) {
        return RetryingExecutorUtil.runWithRetries(() -> this.stub.listSubscriptions(ListSubscriptionsRequest.newBuilder().setParent(ProjectLookupUtils.toCanonical(path).toString()).build()).getSubscriptionsList(), this.listSubscriptionsRetryingExecutor);
    }

    @Override
    public ApiFuture<Subscription> updateSubscription(Subscription subscription, FieldMask mask) {
        return RetryingExecutorUtil.runWithRetries(() -> {
            Subscription canonical = subscription.toBuilder().setName(ProjectLookupUtils.toCanonical(SubscriptionPath.parse(subscription.getName())).toString()).build();
            return this.stub.updateSubscription(UpdateSubscriptionRequest.newBuilder().setSubscription(canonical).setUpdateMask(mask).build());
        }, this.subscriptionRetryingExecutor);
    }

    @Override
    public ApiFuture<Void> deleteSubscription(SubscriptionPath path) {
        return RetryingExecutorUtil.runWithRetries(() -> {
            this.stub.deleteSubscription(DeleteSubscriptionRequest.newBuilder().setName(ProjectLookupUtils.toCanonical(path).toString()).build());
            return null;
        }, this.voidRetryingExecutor);
    }
}

