/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.GoogleLogger;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class ChannelCache {
    private static final GoogleLogger log = GoogleLogger.forEnclosingClass();
    private final Function<String, ManagedChannel> channelFactory;
    private final ConcurrentHashMap<String, Deque<ManagedChannel>> channels = new ConcurrentHashMap();
    private static final int NUMBER_OF_CHANNELS_PER_TARGET = 10;
    private static final String NUMBER_OF_CHANNELS_PER_TARGET_VM_OVERRIDE = "google.cloud.pubsublite.channelCacheSize";

    public ChannelCache() {
        this(ChannelCache::newChannel);
        Runtime.getRuntime().addShutdownHook(new Thread(this::onShutdown));
    }

    @VisibleForTesting
    ChannelCache(Function<String, ManagedChannel> channelFactory) {
        this.channelFactory = channelFactory;
    }

    @VisibleForTesting
    synchronized void onShutdown() {
        this.channels.forEachValue(this.channels.size(), channels -> {
            try {
                for (ManagedChannel channel : channels) {
                    channel.shutdownNow().awaitTermination(60L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }

    public synchronized Channel get(String target) {
        Deque channelQueue = this.channels.computeIfAbsent(target, this::newChannels);
        ManagedChannel channel = (ManagedChannel)channelQueue.removeFirst();
        channelQueue.addLast(channel);
        return channel;
    }

    private Deque<ManagedChannel> newChannels(String target) {
        int numberOfChannels = 10;
        String numberOfChannelsOverride = System.getProperty(NUMBER_OF_CHANNELS_PER_TARGET_VM_OVERRIDE);
        if (numberOfChannelsOverride != null && !numberOfChannelsOverride.isEmpty()) {
            try {
                numberOfChannels = Integer.parseInt(numberOfChannelsOverride);
            }
            catch (NumberFormatException e) {
                ((GoogleLogger.Api)log.atSevere()).log("Unable to parse override for number of channels per target: %s", (Object)numberOfChannelsOverride);
            }
        }
        LinkedList<ManagedChannel> channels = new LinkedList<ManagedChannel>();
        for (int i = 0; i < numberOfChannels; ++i) {
            channels.add(this.channelFactory.apply(target));
        }
        return channels;
    }

    private static ManagedChannel newChannel(String target) {
        return ManagedChannelBuilder.forTarget((String)target).build();
    }
}

