/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.ApiResourceAggregation;
import com.google.cloud.pubsublite.internal.CursorClient;
import com.google.cloud.pubsublite.internal.RetryingExecutorUtil;
import com.google.cloud.pubsublite.proto.CommitCursorRequest;
import com.google.cloud.pubsublite.proto.CommitCursorResponse;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.CursorServiceGrpc;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsRequest;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsResponse;
import com.google.cloud.pubsublite.proto.PartitionCursor;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class CursorClientImpl
extends ApiResourceAggregation
implements CursorClient {
    private final CloudRegion region;
    private final CursorServiceGrpc.CursorServiceBlockingStub stub;
    private final RetryingExecutor<Map<Partition, Offset>> listRetryingExecutor;
    private final RetryingExecutor<Void> voidRetryingExecutor;

    public CursorClientImpl(CloudRegion region, CursorServiceGrpc.CursorServiceBlockingStub stub, RetrySettings retrySettings) {
        this(region, stub, retrySettings, Executors.newScheduledThreadPool(6));
    }

    private CursorClientImpl(CloudRegion region, CursorServiceGrpc.CursorServiceBlockingStub stub, RetrySettings retrySettings, ScheduledExecutorService executor) {
        super(new BackgroundResource[]{new ExecutorAsBackgroundResource((ExecutorService)executor)});
        this.region = region;
        this.stub = stub;
        this.listRetryingExecutor = RetryingExecutorUtil.retryingExecutor(retrySettings, executor);
        this.voidRetryingExecutor = RetryingExecutorUtil.retryingExecutor(retrySettings, executor);
    }

    @Override
    public CloudRegion region() {
        return this.region;
    }

    @Override
    public ApiFuture<Map<Partition, Offset>> listPartitionCursors(SubscriptionPath path) {
        return RetryingExecutorUtil.runWithRetries(() -> {
            ListPartitionCursorsResponse response = this.stub.listPartitionCursors(ListPartitionCursorsRequest.newBuilder().setParent(path.toString()).build());
            ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
            for (PartitionCursor partitionCursor : response.getPartitionCursorsList()) {
                resultBuilder.put((Object)Partition.of(partitionCursor.getPartition()), (Object)Offset.of(partitionCursor.getCursor().getOffset()));
            }
            return resultBuilder.build();
        }, this.listRetryingExecutor);
    }

    @Override
    public ApiFuture<Void> commitCursor(SubscriptionPath path, Partition partition, Offset offset) {
        return RetryingExecutorUtil.runWithRetries(() -> {
            CommitCursorResponse unusedResponse = this.stub.commitCursor(CommitCursorRequest.newBuilder().setSubscription(path.toString()).setPartition(partition.value()).setCursor(Cursor.newBuilder().setOffset(offset.value())).build());
            return null;
        }, this.voidRetryingExecutor);
    }
}

