/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Constants;
import com.google.cloud.pubsublite.Stubs;
import com.google.cloud.pubsublite.internal.AutoValue_CursorClientSettings;
import com.google.cloud.pubsublite.internal.CursorClient;
import com.google.cloud.pubsublite.internal.CursorClientImpl;
import com.google.cloud.pubsublite.proto.CursorServiceGrpc;
import io.grpc.StatusException;
import java.util.Optional;

@AutoValue
public abstract class CursorClientSettings {
    abstract CloudRegion region();

    abstract RetrySettings retrySettings();

    abstract Optional<CursorServiceGrpc.CursorServiceBlockingStub> stub();

    public static Builder newBuilder() {
        return new AutoValue_CursorClientSettings.Builder().setRetrySettings(Constants.DEFAULT_RETRY_SETTINGS);
    }

    CursorClient instantiate() throws StatusException {
        CursorServiceGrpc.CursorServiceBlockingStub stub = this.stub().isPresent() ? this.stub().get() : Stubs.defaultStub(this.region(), CursorServiceGrpc::newBlockingStub);
        return new CursorClientImpl(this.region(), stub, this.retrySettings());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRegion(CloudRegion var1);

        public abstract Builder setRetrySettings(RetrySettings var1);

        public abstract Builder setStub(CursorServiceGrpc.CursorServiceBlockingStub var1);

        public abstract CursorClientSettings build();
    }
}

