/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ExtractStatus {
    public static Optional<Status> extract(Throwable t) {
        try {
            throw t;
        }
        catch (StatusException e) {
            return Optional.of(e.getStatus());
        }
        catch (StatusRuntimeException e) {
            return Optional.of(e.getStatus());
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static StatusException toCanonical(Throwable t) {
        Optional<Status> statusOr = ExtractStatus.extract(t);
        if (statusOr.isPresent()) {
            return statusOr.get().asException();
        }
        return Status.INTERNAL.withCause(t).asException();
    }

    public static void addFailureHandler(ApiFuture<?> future, Consumer<StatusException> consumer) {
        future.addListener(() -> {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                consumer.accept(ExtractStatus.toCanonical(e.getCause()));
            }
            catch (InterruptedException e) {
                consumer.accept(ExtractStatus.toCanonical(e));
            }
        }, MoreExecutors.directExecutor());
    }

    public static <I, O> Function<I, O> rethrowAsRuntime(StatusFunction<I, O> function) {
        return i -> {
            try {
                return function.apply(i);
            }
            catch (StatusException e) {
                throw e.getStatus().asRuntimeException();
            }
        };
    }

    public static <I> Consumer<I> rethrowAsRuntime(StatusConsumer<I> consumer) {
        return i -> {
            try {
                consumer.apply(i);
            }
            catch (StatusException e) {
                throw e.getStatus().asRuntimeException();
            }
        };
    }

    public static <K, V> BiConsumer<K, V> rethrowAsRuntime(StatusBiconsumer<K, V> consumer) {
        return (k, v) -> {
            try {
                consumer.apply(k, v);
            }
            catch (StatusException e) {
                throw e.getStatus().asRuntimeException();
            }
        };
    }

    private ExtractStatus() {
    }

    public static interface StatusBiconsumer<K, V> {
        public void apply(K var1, V var2) throws StatusException;
    }

    public static interface StatusConsumer<I> {
        public void apply(I var1) throws StatusException;
    }

    public static interface StatusFunction<I, O> {
        public O apply(I var1) throws StatusException;
    }
}

