/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.NanoClock;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.cloud.pubsublite.ErrorCodes;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import io.grpc.Status;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;

public final class RetryingExecutorUtil {
    private RetryingExecutorUtil() {
    }

    public static <T> RetryingExecutor<T> retryingExecutor(RetrySettings settings, ScheduledExecutorService executor) {
        return new ScheduledRetryingExecutor(RetryingExecutorUtil.retryAlgorithm(settings), executor);
    }

    public static <T> ApiFuture<T> runWithRetries(Callable<T> callable, RetryingExecutor<T> executor) {
        RetryingFuture retryingFuture = executor.createFuture(callable);
        retryingFuture.setAttemptFuture(executor.submit(retryingFuture));
        return retryingFuture;
    }

    private static <T> RetryAlgorithm<T> retryAlgorithm(RetrySettings retrySettings) {
        return new RetryAlgorithm(RetryingExecutorUtil.resultRetryAlgorithm(), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(retrySettings, NanoClock.getDefaultClock()));
    }

    private static <T> ResultRetryAlgorithm<T> resultRetryAlgorithm() {
        return new ResultRetryAlgorithm<T>(){

            public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, T prevResponse, TimedAttemptSettings prevSettings) {
                return null;
            }

            public boolean shouldRetry(Throwable prevThrowable, T prevResponse) {
                if (null != prevResponse) {
                    return false;
                }
                Optional<Status> statusOr = ExtractStatus.extract(prevThrowable);
                if (!statusOr.isPresent()) {
                    return false;
                }
                return ErrorCodes.IsRetryable(statusOr.get().getCode());
            }
        };
    }
}

