/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectLookupUtils;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ApiResourceAggregation;
import com.google.cloud.pubsublite.internal.RetryingExecutorUtil;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.TopicStatsServiceGrpc;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class TopicStatsClientImpl
extends ApiResourceAggregation
implements TopicStatsClient {
    private final CloudRegion region;
    private final TopicStatsServiceGrpc.TopicStatsServiceBlockingStub stub;
    private final RetryingExecutor<ComputeMessageStatsResponse> retryingExecutor;

    public TopicStatsClientImpl(CloudRegion region, TopicStatsServiceGrpc.TopicStatsServiceBlockingStub stub, RetrySettings retrySettings) {
        this(region, stub, retrySettings, Executors.newScheduledThreadPool(6));
    }

    private TopicStatsClientImpl(CloudRegion region, TopicStatsServiceGrpc.TopicStatsServiceBlockingStub stub, RetrySettings retrySettings, ScheduledExecutorService executor) {
        super(new BackgroundResource[]{new ExecutorAsBackgroundResource((ExecutorService)executor)});
        this.region = region;
        this.stub = stub;
        this.retryingExecutor = RetryingExecutorUtil.retryingExecutor(retrySettings, executor);
    }

    @Override
    public CloudRegion region() {
        return this.region;
    }

    @Override
    public ApiFuture<ComputeMessageStatsResponse> computeMessageStats(TopicPath path, Partition partition, Offset start, Offset end) {
        return RetryingExecutorUtil.runWithRetries(() -> this.stub.computeMessageStats(ComputeMessageStatsRequest.newBuilder().setTopic(ProjectLookupUtils.toCanonical(path).toString()).setPartition(partition.value()).setStartCursor(Cursor.newBuilder().setOffset(start.value()).build()).setEndCursor(Cursor.newBuilder().setOffset(end.value()).build()).build()), this.retryingExecutor);
    }
}

