/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Constants;
import com.google.cloud.pubsublite.Stubs;
import com.google.cloud.pubsublite.internal.AutoValue_TopicStatsClientSettings;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.internal.TopicStatsClientImpl;
import com.google.cloud.pubsublite.proto.TopicStatsServiceGrpc;
import io.grpc.StatusException;
import java.util.Optional;

@AutoValue
public abstract class TopicStatsClientSettings {
    abstract CloudRegion region();

    abstract RetrySettings retrySettings();

    abstract Optional<TopicStatsServiceGrpc.TopicStatsServiceBlockingStub> stub();

    public static Builder newBuilder() {
        return new AutoValue_TopicStatsClientSettings.Builder().setRetrySettings(Constants.DEFAULT_RETRY_SETTINGS);
    }

    TopicStatsClient instantiate() throws StatusException {
        TopicStatsServiceGrpc.TopicStatsServiceBlockingStub stub = this.stub().isPresent() ? this.stub().get() : Stubs.defaultStub(this.region(), TopicStatsServiceGrpc::newBlockingStub);
        return new TopicStatsClientImpl(this.region(), stub, this.retrySettings());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRegion(CloudRegion var1);

        public abstract Builder setRetrySettings(RetrySettings var1);

        public abstract Builder setStub(TopicStatsServiceGrpc.TopicStatsServiceBlockingStub var1);

        public abstract TopicStatsClientSettings build();
    }
}

