/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.ProjectLookupUtils;
import com.google.cloud.pubsublite.Stubs;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.wire.Assigner;
import com.google.cloud.pubsublite.internal.wire.AssignerImpl;
import com.google.cloud.pubsublite.internal.wire.AutoValue_AssignerBuilder;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssignerImpl;
import com.google.cloud.pubsublite.internal.wire.PartitionAssignmentReceiver;
import com.google.cloud.pubsublite.proto.InitialPartitionAssignmentRequest;
import com.google.cloud.pubsublite.proto.PartitionAssignmentServiceGrpc;
import com.google.common.flogger.GoogleLogger;
import com.google.protobuf.ByteString;
import io.grpc.StatusException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;

@AutoValue
public abstract class AssignerBuilder {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    abstract SubscriptionPath subscriptionPath();

    abstract PartitionAssignmentReceiver receiver();

    abstract Optional<PartitionAssignmentServiceGrpc.PartitionAssignmentServiceStub> assignmentStub();

    public static Builder newBuilder() {
        return new AutoValue_AssignerBuilder.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setReceiver(PartitionAssignmentReceiver var1);

        public abstract Builder setAssignmentStub(PartitionAssignmentServiceGrpc.PartitionAssignmentServiceStub var1);

        abstract AssignerBuilder autoBuild();

        public Assigner build() throws StatusException {
            AssignerBuilder builder = this.autoBuild();
            PartitionAssignmentServiceGrpc.PartitionAssignmentServiceStub stub = builder.assignmentStub().isPresent() ? builder.assignmentStub().get() : Stubs.defaultStub(builder.subscriptionPath().location().region(), PartitionAssignmentServiceGrpc::newStub);
            UUID uuid = UUID.randomUUID();
            ByteBuffer uuidBuffer = ByteBuffer.allocate(16);
            uuidBuffer.putLong(uuid.getMostSignificantBits());
            uuidBuffer.putLong(uuid.getLeastSignificantBits());
            ((GoogleLogger.Api)logger.atInfo()).log("Subscription %s using UUID %s for assignment.", (Object)builder.subscriptionPath(), (Object)uuid);
            InitialPartitionAssignmentRequest initial = InitialPartitionAssignmentRequest.newBuilder().setSubscription(ProjectLookupUtils.toCanonical(builder.subscriptionPath()).toString()).setClientId(ByteString.copyFrom((byte[])uuidBuffer.array())).build();
            return new AssignerImpl(stub, new ConnectedAssignerImpl.Factory(), initial, builder.receiver());
        }
    }
}

