/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiService;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.TrivialProxyService;
import com.google.cloud.pubsublite.internal.wire.Assigner;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssigner;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssignerFactory;
import com.google.cloud.pubsublite.internal.wire.PartitionAssignmentReceiver;
import com.google.cloud.pubsublite.internal.wire.RetryingConnection;
import com.google.cloud.pubsublite.internal.wire.RetryingConnectionImpl;
import com.google.cloud.pubsublite.internal.wire.RetryingConnectionObserver;
import com.google.cloud.pubsublite.proto.InitialPartitionAssignmentRequest;
import com.google.cloud.pubsublite.proto.PartitionAssignment;
import com.google.cloud.pubsublite.proto.PartitionAssignmentRequest;
import com.google.cloud.pubsublite.proto.PartitionAssignmentServiceGrpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.grpc.StatusException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AssignerImpl
extends TrivialProxyService
implements Assigner,
RetryingConnectionObserver<PartitionAssignment> {
    @GuardedBy(value="monitor.monitor")
    private final RetryingConnection<ConnectedAssigner> connection;
    @GuardedBy(value="monitor.monitor")
    private final PartitionAssignmentReceiver receiver;
    private final CloseableMonitor monitor = new CloseableMonitor();

    @VisibleForTesting
    AssignerImpl(PartitionAssignmentServiceGrpc.PartitionAssignmentServiceStub stub, ConnectedAssignerFactory factory, InitialPartitionAssignmentRequest initialRequest, PartitionAssignmentReceiver receiver) throws StatusException {
        super(new ApiService[0]);
        this.receiver = receiver;
        this.connection = new RetryingConnectionImpl<PartitionAssignmentRequest, PartitionAssignment, PartitionAssignment, ConnectedAssigner>(arg_0 -> ((PartitionAssignmentServiceGrpc.PartitionAssignmentServiceStub)stub).assignPartitions(arg_0), factory, PartitionAssignmentRequest.newBuilder().setInitial(initialRequest).build(), this);
        this.addServices(this.connection);
    }

    @Override
    public void triggerReinitialize() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            this.connection.reinitialize();
        }
    }

    private static Set<Partition> toSet(PartitionAssignment assignment) throws StatusException {
        HashSet<Partition> partitions = new HashSet<Partition>();
        Iterator iterator = assignment.getPartitionsList().iterator();
        while (iterator.hasNext()) {
            long partition = (Long)iterator.next();
            partitions.add(Partition.of(partition));
        }
        return partitions;
    }

    @Override
    public void onClientResponse(PartitionAssignment value) throws StatusException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            this.receiver.handleAssignment(AssignerImpl.toSet(value));
            this.connection.modifyConnection(connectionOr -> connectionOr.ifPresent(ConnectedAssigner::ack));
        }
    }
}

