/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.wire.PublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.proto.PublisherServiceGrpc;
import java.util.Optional;

final class AutoValue_SinglePartitionPublisherBuilder
extends SinglePartitionPublisherBuilder {
    private final TopicPath topic;
    private final Partition partition;
    private final Optional<PublisherServiceGrpc.PublisherServiceStub> stub;
    private final Optional<BatchingSettings> batchingSettings;
    private final PubsubContext context;
    private final PublisherBuilder.Builder underlyingBuilder;

    private AutoValue_SinglePartitionPublisherBuilder(TopicPath topic, Partition partition, Optional<PublisherServiceGrpc.PublisherServiceStub> stub, Optional<BatchingSettings> batchingSettings, PubsubContext context, PublisherBuilder.Builder underlyingBuilder) {
        this.topic = topic;
        this.partition = partition;
        this.stub = stub;
        this.batchingSettings = batchingSettings;
        this.context = context;
        this.underlyingBuilder = underlyingBuilder;
    }

    @Override
    TopicPath topic() {
        return this.topic;
    }

    @Override
    Partition partition() {
        return this.partition;
    }

    @Override
    Optional<PublisherServiceGrpc.PublisherServiceStub> stub() {
        return this.stub;
    }

    @Override
    Optional<BatchingSettings> batchingSettings() {
        return this.batchingSettings;
    }

    @Override
    PubsubContext context() {
        return this.context;
    }

    @Override
    PublisherBuilder.Builder underlyingBuilder() {
        return this.underlyingBuilder;
    }

    public String toString() {
        return "SinglePartitionPublisherBuilder{topic=" + this.topic + ", partition=" + this.partition + ", stub=" + this.stub + ", batchingSettings=" + this.batchingSettings + ", context=" + this.context + ", underlyingBuilder=" + this.underlyingBuilder + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SinglePartitionPublisherBuilder) {
            SinglePartitionPublisherBuilder that = (SinglePartitionPublisherBuilder)o;
            return this.topic.equals(that.topic()) && this.partition.equals(that.partition()) && this.stub.equals(that.stub()) && this.batchingSettings.equals(that.batchingSettings()) && this.context.equals(that.context()) && this.underlyingBuilder.equals(that.underlyingBuilder());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        h$ ^= this.stub.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchingSettings.hashCode();
        h$ *= 1000003;
        h$ ^= this.context.hashCode();
        h$ *= 1000003;
        return h$ ^= this.underlyingBuilder.hashCode();
    }

    static final class Builder
    extends SinglePartitionPublisherBuilder.Builder {
        private TopicPath topic;
        private Partition partition;
        private Optional<PublisherServiceGrpc.PublisherServiceStub> stub = Optional.empty();
        private Optional<BatchingSettings> batchingSettings = Optional.empty();
        private PubsubContext context;
        private PublisherBuilder.Builder underlyingBuilder;

        Builder() {
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setTopic(TopicPath topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setPartition(Partition partition) {
            if (partition == null) {
                throw new NullPointerException("Null partition");
            }
            this.partition = partition;
            return this;
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setStub(Optional<PublisherServiceGrpc.PublisherServiceStub> stub) {
            if (stub == null) {
                throw new NullPointerException("Null stub");
            }
            this.stub = stub;
            return this;
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setBatchingSettings(Optional<BatchingSettings> batchingSettings) {
            if (batchingSettings == null) {
                throw new NullPointerException("Null batchingSettings");
            }
            this.batchingSettings = batchingSettings;
            return this;
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setContext(PubsubContext context) {
            if (context == null) {
                throw new NullPointerException("Null context");
            }
            this.context = context;
            return this;
        }

        @Override
        SinglePartitionPublisherBuilder.Builder setUnderlyingBuilder(PublisherBuilder.Builder underlyingBuilder) {
            if (underlyingBuilder == null) {
                throw new NullPointerException("Null underlyingBuilder");
            }
            this.underlyingBuilder = underlyingBuilder;
            return this;
        }

        @Override
        SinglePartitionPublisherBuilder autoBuild() {
            String missing = "";
            if (this.topic == null) {
                missing = missing + " topic";
            }
            if (this.partition == null) {
                missing = missing + " partition";
            }
            if (this.context == null) {
                missing = missing + " context";
            }
            if (this.underlyingBuilder == null) {
                missing = missing + " underlyingBuilder";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SinglePartitionPublisherBuilder(this.topic, this.partition, this.stub, this.batchingSettings, this.context, this.underlyingBuilder);
        }
    }
}

