/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectLookupUtils;
import com.google.cloud.pubsublite.Stubs;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.wire.AutoValue_CommitterBuilder;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.CommitterImpl;
import com.google.cloud.pubsublite.proto.CursorServiceGrpc;
import com.google.cloud.pubsublite.proto.InitialCommitCursorRequest;
import io.grpc.StatusException;
import java.util.Optional;

@AutoValue
public abstract class CommitterBuilder {
    abstract SubscriptionPath subscriptionPath();

    abstract Partition partition();

    abstract Optional<CursorServiceGrpc.CursorServiceStub> cursorStub();

    public static Builder newBuilder() {
        return new AutoValue_CommitterBuilder.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setCursorStub(CursorServiceGrpc.CursorServiceStub var1);

        abstract CommitterBuilder autoBuild();

        public Committer build() throws StatusException {
            CommitterBuilder builder = this.autoBuild();
            CursorServiceGrpc.CursorServiceStub cursorStub = builder.cursorStub().isPresent() ? builder.cursorStub().get() : Stubs.defaultStub(builder.subscriptionPath().location().region(), CursorServiceGrpc::newStub);
            InitialCommitCursorRequest initialCommitCursorRequest = InitialCommitCursorRequest.newBuilder().setSubscription(ProjectLookupUtils.toCanonical(builder.subscriptionPath()).toString()).setPartition(builder.partition().value()).build();
            return new CommitterImpl(cursorStub, initialCommitCursorRequest);
        }
    }
}

