/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssigner;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssignerFactory;
import com.google.cloud.pubsublite.internal.wire.SingleConnection;
import com.google.cloud.pubsublite.internal.wire.StreamFactory;
import com.google.cloud.pubsublite.proto.PartitionAssignment;
import com.google.cloud.pubsublite.proto.PartitionAssignmentAck;
import com.google.cloud.pubsublite.proto.PartitionAssignmentRequest;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;

public class ConnectedAssignerImpl
extends SingleConnection<PartitionAssignmentRequest, PartitionAssignment, PartitionAssignment>
implements ConnectedAssigner {
    private final CloseableMonitor monitor = new CloseableMonitor();
    @GuardedBy(value="monitor.monitor")
    boolean outstanding = false;

    private ConnectedAssignerImpl(StreamFactory<PartitionAssignmentRequest, PartitionAssignment> streamFactory, StreamObserver<PartitionAssignment> clientStream, PartitionAssignmentRequest initialRequest) {
        super(streamFactory, clientStream);
        this.initialize(initialRequest);
    }

    @Override
    protected void handleInitialResponse(PartitionAssignment response) throws StatusException {
        this.handleStreamResponse(response);
    }

    @Override
    protected void handleStreamResponse(PartitionAssignment response) throws StatusException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            Preconditions.checkState(!this.outstanding, "Received assignment from the server while there was an assignment outstanding.");
            this.outstanding = true;
        }
        this.sendToClient(response);
    }

    @Override
    public void ack() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            Preconditions.checkState(this.outstanding, "Client acknowledged when there was no request outstanding.");
            this.outstanding = false;
        }
        catch (StatusException e) {
            this.setError(e);
        }
        this.sendToStream(PartitionAssignmentRequest.newBuilder().setAck(PartitionAssignmentAck.getDefaultInstance()).build());
    }

    static class Factory
    implements ConnectedAssignerFactory {
        Factory() {
        }

        @Override
        public ConnectedAssigner New(StreamFactory<PartitionAssignmentRequest, PartitionAssignment> streamFactory, StreamObserver<PartitionAssignment> clientStream, PartitionAssignmentRequest initialRequest) {
            return new ConnectedAssignerImpl(streamFactory, clientStream, initialRequest);
        }
    }
}

