/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowController;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectLookupUtils;
import com.google.cloud.pubsublite.Stubs;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.AutoValue_PublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.PublisherImpl;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.proto.InitialPublishRequest;
import com.google.cloud.pubsublite.proto.PublisherServiceGrpc;
import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.StatusException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import java.util.Optional;
import org.threeten.bp.Duration;

@AutoValue
public abstract class PublisherBuilder {
    public static final BatchingSettings DEFAULT_BATCHING_SETTINGS = BatchingSettings.newBuilder().setDelayThreshold(Duration.ofMillis((long)50L)).setElementCountThreshold(Long.valueOf(1000L)).setRequestByteThreshold(Long.valueOf(3500000L)).setIsEnabled(Boolean.valueOf(true)).build();
    public static final BatchingSettings DISABLED_BATCHING_SETTINGS = BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(1L)).setRequestByteThreshold(Long.valueOf(1L)).setIsEnabled(Boolean.valueOf(true)).build();

    abstract TopicPath topic();

    abstract Partition partition();

    abstract BatchingSettings batching();

    abstract Optional<PublisherServiceGrpc.PublisherServiceStub> stub();

    abstract PubsubContext context();

    public static Builder builder() {
        AutoValue_PublisherBuilder.Builder impl = new AutoValue_PublisherBuilder.Builder();
        return ((Builder)impl).setBatching(DEFAULT_BATCHING_SETTINGS).setContext(PubsubContext.of());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopic(TopicPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setBatching(BatchingSettings var1);

        public abstract Builder setStub(PublisherServiceGrpc.PublisherServiceStub var1);

        public abstract Builder setContext(PubsubContext var1);

        abstract PublisherBuilder autoBuild();

        public Publisher<Offset> build() throws StatusException {
            PublisherBuilder autoBuilt = this.autoBuild();
            PublisherServiceGrpc.PublisherServiceStub actualStub = autoBuilt.stub().isPresent() ? autoBuilt.stub().get() : Stubs.defaultStub(autoBuilt.topic().location().region(), PublisherServiceGrpc::newStub);
            Metadata metadata = autoBuilt.context().getMetadata();
            metadata.merge(RoutingMetadata.of(autoBuilt.topic(), autoBuilt.partition()));
            actualStub = (PublisherServiceGrpc.PublisherServiceStub)MetadataUtils.attachHeaders((AbstractStub)actualStub, (Metadata)metadata);
            return new PublisherImpl(actualStub, InitialPublishRequest.newBuilder().setTopic(ProjectLookupUtils.toCanonical(autoBuilt.topic()).toString()).setPartition(autoBuilt.partition().value()).build(), Builder.validateBatchingSettings(autoBuilt.batching()));
        }

        static BatchingSettings validateBatchingSettings(BatchingSettings batching) {
            Preconditions.checkArgument((boolean)batching.getFlowControlSettings().getLimitExceededBehavior().equals((Object)FlowController.LimitExceededBehavior.Ignore), (Object)"Publisher does not accept flow control settings as the behavior would be non-obvious given a Publisher implementation. Use external flow control instead.");
            if (!batching.getIsEnabled().booleanValue()) {
                return DISABLED_BATCHING_SETTINGS;
            }
            Preconditions.checkNotNull((Object)batching.getElementCountThreshold());
            Preconditions.checkNotNull((Object)batching.getRequestByteThreshold());
            Preconditions.checkArgument((batching.getElementCountThreshold() <= 1000L ? 1 : 0) != 0, (Object)"Batching element count greater than max value.");
            Preconditions.checkArgument((batching.getRequestByteThreshold() <= 3500000L ? 1 : 0) != 0, (Object)"Batching byte count greater than max value.");
            return batching;
        }
    }
}

