/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PublishMetadata;
import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.RoutingPolicy;
import com.google.cloud.pubsublite.internal.TrivialProxyService;
import io.grpc.StatusException;
import java.io.IOException;
import java.util.Map;

public class RoutingPublisher
extends TrivialProxyService
implements Publisher<PublishMetadata> {
    private final Map<Partition, Publisher<PublishMetadata>> partitionPublishers;
    private final RoutingPolicy policy;

    RoutingPublisher(Map<Partition, Publisher<PublishMetadata>> partitionPublishers, RoutingPolicy policy) throws StatusException {
        super(partitionPublishers.values());
        this.partitionPublishers = partitionPublishers;
        this.policy = policy;
    }

    @Override
    public ApiFuture<PublishMetadata> publish(Message message) {
        try {
            Partition routedPartition = message.key().isEmpty() ? this.policy.routeWithoutKey() : this.policy.route(message.key());
            Preconditions.checkState(this.partitionPublishers.containsKey(routedPartition), String.format("Routed to partition %s for which there is no publisher available.", routedPartition));
            return this.partitionPublishers.get(routedPartition).publish(message);
        }
        catch (StatusException e) {
            this.onPermanentError(e);
            return ApiFutures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public void flush() throws IOException {
        for (Publisher<PublishMetadata> publisher : this.partitionPublishers.values()) {
            publisher.flush();
        }
    }
}

