/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PartitionLookupUtils;
import com.google.cloud.pubsublite.PublishMetadata;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.DefaultRoutingPolicy;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.AutoValue_RoutingPublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.RoutingPublisher;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.common.collect.ImmutableMap;
import io.grpc.StatusException;
import java.util.Map;
import java.util.Optional;

@AutoValue
public abstract class RoutingPublisherBuilder {
    abstract TopicPath topic();

    abstract SinglePartitionPublisherBuilder.Builder publisherBuilder();

    abstract Optional<Integer> numPartitions();

    public static Builder newBuilder() {
        return new AutoValue_RoutingPublisherBuilder.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopic(TopicPath var1);

        public abstract Builder setPublisherBuilder(SinglePartitionPublisherBuilder.Builder var1);

        public abstract Builder setNumPartitions(Integer var1);

        abstract RoutingPublisherBuilder autoBuild();

        public Publisher<PublishMetadata> build() throws StatusException {
            RoutingPublisherBuilder builder = this.autoBuild();
            int numPartitions = builder.numPartitions().isPresent() ? builder.numPartitions().get() : PartitionLookupUtils.numPartitions(builder.topic());
            ImmutableMap.Builder publisherMapBuilder = ImmutableMap.builder();
            for (int i = 0; i < numPartitions; ++i) {
                publisherMapBuilder.put((Object)Partition.of(i), builder.publisherBuilder().setTopic(builder.topic()).setPartition(Partition.of(i)).build());
            }
            return new RoutingPublisher((Map<Partition, Publisher<PublishMetadata>>)publisherMapBuilder.build(), new DefaultRoutingPolicy(numPartitions));
        }
    }
}

