/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.wire.StreamFactory;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.Monitor;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;

public abstract class SingleConnection<StreamRequestT, StreamResponseT, ClientResponseT>
implements StreamObserver<StreamResponseT>,
AutoCloseable {
    private static final GoogleLogger log = GoogleLogger.forEnclosingClass();
    private final StreamObserver<StreamRequestT> requestStream;
    private final StreamObserver<ClientResponseT> clientStream;
    private final CloseableMonitor connectionMonitor = new CloseableMonitor();
    @GuardedBy(value="connectionMonitor.monitor")
    private boolean receivedInitial = false;
    @GuardedBy(value="connectionMonitor.monitor")
    private boolean completed = false;

    protected abstract void handleInitialResponse(StreamResponseT var1) throws StatusException;

    protected abstract void handleStreamResponse(StreamResponseT var1) throws StatusException;

    protected SingleConnection(StreamFactory<StreamRequestT, StreamResponseT> streamFactory, StreamObserver<ClientResponseT> clientStream) {
        this.clientStream = clientStream;
        this.requestStream = streamFactory.New(this);
    }

    protected void initialize(StreamRequestT initialRequest) {
        this.requestStream.onNext(initialRequest);
        CloseableMonitor.Hold h = this.connectionMonitor.enterWhenUninterruptibly(new Monitor.Guard(this.connectionMonitor.monitor){

            public boolean isSatisfied() {
                return SingleConnection.this.receivedInitial || SingleConnection.this.completed;
            }
        });
        Throwable throwable = null;
        if (h != null) {
            if (throwable != null) {
                try {
                    h.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                h.close();
            }
        }
    }

    protected void sendToStream(StreamRequestT request) {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                ((GoogleLogger.Api)log.atFine()).log("Sent request after stream completion: %s", request);
                return;
            }
            Preconditions.checkState((boolean)this.receivedInitial);
            this.requestStream.onNext(request);
        }
    }

    protected void sendToClient(ClientResponseT response) {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                ((GoogleLogger.Api)log.atFine()).log("Sent response after stream completion: %s", response);
                return;
            }
            Preconditions.checkState((boolean)this.receivedInitial);
        }
        this.clientStream.onNext(response);
    }

    protected void setError(StatusException error) {
        this.abort(error);
    }

    protected boolean isCompleted() {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            boolean bl = this.completed;
            return bl;
        }
    }

    @Override
    public void close() {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                return;
            }
            this.completed = true;
        }
        this.requestStream.onCompleted();
        this.clientStream.onCompleted();
    }

    private void abort(StatusException error) {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                return;
            }
            this.completed = true;
        }
        this.requestStream.onError((Throwable)error);
        this.clientStream.onError((Throwable)error);
    }

    public void onNext(StreamResponseT response) {
        boolean isFirst;
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                ((GoogleLogger.Api)log.atFine()).log("Received response on stream after completion: %s", response);
                return;
            }
            isFirst = !this.receivedInitial;
            this.receivedInitial = true;
        }
        try {
            if (isFirst) {
                this.handleInitialResponse(response);
            } else {
                this.handleStreamResponse(response);
            }
        }
        catch (StatusException e) {
            this.abort(e);
        }
    }

    public void onError(Throwable t) {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                return;
            }
            this.completed = true;
        }
        this.clientStream.onError(t);
    }

    public void onCompleted() {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.clientStream.onCompleted();
        }
    }
}

