/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.cloud.pubsublite.proto.FlowControlRequest;
import com.google.common.math.LongMath;
import io.grpc.StatusException;
import java.util.Optional;

class TokenCounter {
    private long bytes = 0L;
    private long messages = 0L;

    TokenCounter() {
    }

    void add(long deltaBytes, long deltaMessages) throws StatusException {
        Preconditions.checkArgument(deltaBytes >= 0L);
        Preconditions.checkArgument(deltaMessages >= 0L);
        this.bytes = LongMath.saturatedAdd((long)this.bytes, (long)deltaBytes);
        this.messages = LongMath.saturatedAdd((long)this.messages, (long)deltaMessages);
    }

    void sub(long deltaBytes, long deltaMessages) throws StatusException {
        Preconditions.checkArgument(deltaBytes >= 0L);
        Preconditions.checkArgument(deltaMessages >= 0L);
        Preconditions.checkState(deltaBytes <= this.bytes, "Received messages that account for more bytes than were requested.");
        Preconditions.checkState(deltaMessages <= this.messages, "Received more messages than were requested.");
        this.bytes -= deltaBytes;
        this.messages -= deltaMessages;
    }

    void reset() {
        this.bytes = 0L;
        this.messages = 0L;
    }

    long bytes() {
        return this.bytes;
    }

    long messages() {
        return this.messages;
    }

    Optional<FlowControlRequest> toFlowControlRequest() {
        if (this.bytes == 0L && this.messages == 0L) {
            return Optional.empty();
        }
        return Optional.of(FlowControlRequest.newBuilder().setAllowedBytes(this.bytes).setAllowedMessages(this.messages).build());
    }
}

