/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.proto.Subscription;
import java.util.concurrent.ExecutionException;

public final class PartitionLookupUtils {
    private PartitionLookupUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int numPartitions(TopicPath topic) throws ApiException {
        try (AdminClient client = AdminClient.create(AdminClientSettings.newBuilder().setRegion(topic.location().region()).build());){
            int n = PartitionLookupUtils.numPartitions(topic, client);
            return n;
        }
        catch (Exception e) {
            throw ExtractStatus.toCanonical((Throwable)e).underlying;
        }
    }

    public static int numPartitions(TopicPath topic, AdminClient client) throws ApiException {
        ApiFuture<Long> partitionCountFuture = client.getTopicPartitionCount(topic);
        try {
            long numPartitions = (Long)partitionCountFuture.get();
            UncheckedApiPreconditions.checkState(numPartitions > 0L, "Config has 0 or less partitions configured. This config is invalid.");
            UncheckedApiPreconditions.checkState(numPartitions < Integer.MAX_VALUE, "Config has more than Integer.MAX_VALUE partitions configured. This config cannot be used with this client library.");
            return (int)numPartitions;
        }
        catch (ExecutionException e) {
            throw ExtractStatus.toCanonical((Throwable)e.getCause()).underlying;
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int numPartitions(SubscriptionPath subscription) throws ApiException {
        try (AdminClient client = AdminClient.create(AdminClientSettings.newBuilder().setRegion(subscription.location().region()).build());){
            int n = PartitionLookupUtils.numPartitions(subscription, client);
            return n;
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    public static int numPartitions(SubscriptionPath subscription, AdminClient client) throws ApiException {
        ApiFuture<Subscription> subscriptionFuture = client.getSubscription(subscription);
        try {
            return PartitionLookupUtils.numPartitions(TopicPath.parse(((Subscription)subscriptionFuture.get()).getTopic()), client);
        }
        catch (ExecutionException e) {
            throw ExtractStatus.toCanonical((Throwable)e.getCause()).underlying;
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }
}

