/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.ProjectLookupUtils;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.AutoValue_PublisherSettings;
import com.google.cloud.pubsublite.cloudpubsub.KeyExtractor;
import com.google.cloud.pubsublite.cloudpubsub.MessageTransforms;
import com.google.cloud.pubsublite.cloudpubsub.Publisher;
import com.google.cloud.pubsublite.cloudpubsub.internal.WrappingPublisher;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingPublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Optional;
import java.util.function.Supplier;
import org.threeten.bp.Duration;

@AutoValue
public abstract class PublisherSettings {
    public static final BatchingSettings DEFAULT_BATCHING_SETTINGS = BatchingSettings.newBuilder().setIsEnabled(Boolean.valueOf(true)).setElementCountThreshold(Long.valueOf(1000L)).setRequestByteThreshold(Long.valueOf(3500000L)).setDelayThreshold(Duration.ofMillis((long)50L)).build();
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of("CLOUD_PUBSUB_SHIM");

    abstract TopicPath topicPath();

    abstract Optional<KeyExtractor> keyExtractor();

    abstract Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer();

    abstract Optional<BatchingSettings> batchingSettings();

    abstract Optional<Supplier<PublisherServiceClient>> serviceClientSupplier();

    abstract SinglePartitionPublisherBuilder.Builder underlyingBuilder();

    abstract Optional<Integer> numPartitions();

    public static Builder newBuilder() {
        return new AutoValue_PublisherSettings.Builder().setUnderlyingBuilder(SinglePartitionPublisherBuilder.newBuilder());
    }

    Publisher instantiate() throws ApiException {
        BatchingSettings batchingSettings = this.batchingSettings().orElse(DEFAULT_BATCHING_SETTINGS);
        KeyExtractor keyExtractor = this.keyExtractor().orElse(KeyExtractor.DEFAULT);
        MessageTransformer messageTransformer = this.messageTransformer().orElseGet(() -> MessageTransforms.fromCpsPublishTransformer(keyExtractor));
        TopicPath canonicalTopic = ProjectLookupUtils.toCanonical(this.topicPath());
        RoutingPublisherBuilder.Builder wireBuilder = RoutingPublisherBuilder.newBuilder().setTopic(canonicalTopic).setPublisherFactory(partition -> {
            SinglePartitionPublisherBuilder.Builder singlePartitionBuilder = this.underlyingBuilder().setBatchingSettings(batchingSettings).setContext(PubsubContext.of(FRAMEWORK)).setTopic(canonicalTopic).setPartition(partition);
            this.serviceClientSupplier().ifPresent(supplier -> singlePartitionBuilder.setServiceClient((PublisherServiceClient)supplier.get()));
            return singlePartitionBuilder.build();
        });
        this.numPartitions().ifPresent(wireBuilder::setNumPartitions);
        return new WrappingPublisher(wireBuilder.build(), messageTransformer);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopicPath(TopicPath var1);

        public abstract Builder setKeyExtractor(KeyExtractor var1);

        public abstract Builder setMessageTransformer(MessageTransformer<PubsubMessage, Message> var1);

        public abstract Builder setBatchingSettings(BatchingSettings var1);

        public abstract Builder setServiceClientSupplier(Supplier<PublisherServiceClient> var1);

        abstract Builder setUnderlyingBuilder(SinglePartitionPublisherBuilder.Builder var1);

        abstract Builder setNumPartitions(int var1);

        public abstract PublisherSettings build();
    }
}

