/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.ProjectLookupUtils;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.Assigner;
import com.google.cloud.pubsublite.internal.wire.AssignerImpl;
import com.google.cloud.pubsublite.internal.wire.AutoValue_AssignerBuilder;
import com.google.cloud.pubsublite.internal.wire.PartitionAssignmentReceiver;
import com.google.cloud.pubsublite.proto.InitialPartitionAssignmentRequest;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceClient;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceSettings;
import com.google.common.flogger.GoogleLogger;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;

@AutoValue
public abstract class AssignerBuilder {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    abstract SubscriptionPath subscriptionPath();

    abstract PartitionAssignmentReceiver receiver();

    abstract Optional<PartitionAssignmentServiceClient> serviceClient();

    public static Builder newBuilder() {
        return new AutoValue_AssignerBuilder.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setReceiver(PartitionAssignmentReceiver var1);

        public abstract Builder setServiceClient(PartitionAssignmentServiceClient var1);

        abstract AssignerBuilder autoBuild();

        public Assigner build() throws ApiException {
            PartitionAssignmentServiceClient serviceClient;
            AssignerBuilder builder = this.autoBuild();
            if (builder.serviceClient().isPresent()) {
                serviceClient = builder.serviceClient().get();
            } else {
                try {
                    serviceClient = PartitionAssignmentServiceClient.create((PartitionAssignmentServiceSettings)((Object)ServiceClients.addDefaultSettings(builder.subscriptionPath().location().region(), PartitionAssignmentServiceSettings.newBuilder())));
                }
                catch (Throwable t) {
                    throw ExtractStatus.toCanonical((Throwable)t).underlying;
                }
            }
            UUID uuid = UUID.randomUUID();
            ByteBuffer uuidBuffer = ByteBuffer.allocate(16);
            uuidBuffer.putLong(uuid.getMostSignificantBits());
            uuidBuffer.putLong(uuid.getLeastSignificantBits());
            ((GoogleLogger.Api)logger.atInfo()).log("Subscription %s using UUID %s for assignment.", (Object)builder.subscriptionPath(), (Object)uuid);
            InitialPartitionAssignmentRequest initial = InitialPartitionAssignmentRequest.newBuilder().setSubscription(ProjectLookupUtils.toCanonical(builder.subscriptionPath()).toString()).setClientId(ByteString.copyFrom((byte[])uuidBuffer.array())).build();
            return new AssignerImpl(serviceClient, initial, builder.receiver());
        }
    }
}

