package com.google.cloud.pubsublite.cloudpubsub;

import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceClient;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import com.google.pubsub.v1.PubsubMessage;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SubscriberSettings extends SubscriberSettings {

  private final MessageReceiver receiver;

  private final SubscriptionPath subscriptionPath;

  private final FlowControlSettings perPartitionFlowControlSettings;

  private final Optional<List<Partition>> partitions;

  private final Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer;

  private final Optional<Supplier<SubscriberServiceClient>> subscriberServiceClientSupplier;

  private final Optional<Supplier<CursorServiceClient>> cursorServiceClientSupplier;

  private final Optional<PartitionAssignmentServiceClient> assignmentServiceClient;

  private final Optional<NackHandler> nackHandler;

  private AutoValue_SubscriberSettings(
      MessageReceiver receiver,
      SubscriptionPath subscriptionPath,
      FlowControlSettings perPartitionFlowControlSettings,
      Optional<List<Partition>> partitions,
      Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer,
      Optional<Supplier<SubscriberServiceClient>> subscriberServiceClientSupplier,
      Optional<Supplier<CursorServiceClient>> cursorServiceClientSupplier,
      Optional<PartitionAssignmentServiceClient> assignmentServiceClient,
      Optional<NackHandler> nackHandler) {
    this.receiver = receiver;
    this.subscriptionPath = subscriptionPath;
    this.perPartitionFlowControlSettings = perPartitionFlowControlSettings;
    this.partitions = partitions;
    this.transformer = transformer;
    this.subscriberServiceClientSupplier = subscriberServiceClientSupplier;
    this.cursorServiceClientSupplier = cursorServiceClientSupplier;
    this.assignmentServiceClient = assignmentServiceClient;
    this.nackHandler = nackHandler;
  }

  @Override
  MessageReceiver receiver() {
    return receiver;
  }

  @Override
  SubscriptionPath subscriptionPath() {
    return subscriptionPath;
  }

  @Override
  FlowControlSettings perPartitionFlowControlSettings() {
    return perPartitionFlowControlSettings;
  }

  @Override
  Optional<List<Partition>> partitions() {
    return partitions;
  }

  @Override
  Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer() {
    return transformer;
  }

  @Override
  Optional<Supplier<SubscriberServiceClient>> subscriberServiceClientSupplier() {
    return subscriberServiceClientSupplier;
  }

  @Override
  Optional<Supplier<CursorServiceClient>> cursorServiceClientSupplier() {
    return cursorServiceClientSupplier;
  }

  @Override
  Optional<PartitionAssignmentServiceClient> assignmentServiceClient() {
    return assignmentServiceClient;
  }

  @Override
  Optional<NackHandler> nackHandler() {
    return nackHandler;
  }

  @Override
  public String toString() {
    return "SubscriberSettings{"
        + "receiver=" + receiver + ", "
        + "subscriptionPath=" + subscriptionPath + ", "
        + "perPartitionFlowControlSettings=" + perPartitionFlowControlSettings + ", "
        + "partitions=" + partitions + ", "
        + "transformer=" + transformer + ", "
        + "subscriberServiceClientSupplier=" + subscriberServiceClientSupplier + ", "
        + "cursorServiceClientSupplier=" + cursorServiceClientSupplier + ", "
        + "assignmentServiceClient=" + assignmentServiceClient + ", "
        + "nackHandler=" + nackHandler
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SubscriberSettings) {
      SubscriberSettings that = (SubscriberSettings) o;
      return this.receiver.equals(that.receiver())
          && this.subscriptionPath.equals(that.subscriptionPath())
          && this.perPartitionFlowControlSettings.equals(that.perPartitionFlowControlSettings())
          && this.partitions.equals(that.partitions())
          && this.transformer.equals(that.transformer())
          && this.subscriberServiceClientSupplier.equals(that.subscriberServiceClientSupplier())
          && this.cursorServiceClientSupplier.equals(that.cursorServiceClientSupplier())
          && this.assignmentServiceClient.equals(that.assignmentServiceClient())
          && this.nackHandler.equals(that.nackHandler());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= receiver.hashCode();
    h$ *= 1000003;
    h$ ^= subscriptionPath.hashCode();
    h$ *= 1000003;
    h$ ^= perPartitionFlowControlSettings.hashCode();
    h$ *= 1000003;
    h$ ^= partitions.hashCode();
    h$ *= 1000003;
    h$ ^= transformer.hashCode();
    h$ *= 1000003;
    h$ ^= subscriberServiceClientSupplier.hashCode();
    h$ *= 1000003;
    h$ ^= cursorServiceClientSupplier.hashCode();
    h$ *= 1000003;
    h$ ^= assignmentServiceClient.hashCode();
    h$ *= 1000003;
    h$ ^= nackHandler.hashCode();
    return h$;
  }

  static final class Builder extends SubscriberSettings.Builder {
    private MessageReceiver receiver;
    private SubscriptionPath subscriptionPath;
    private FlowControlSettings perPartitionFlowControlSettings;
    private Optional<List<Partition>> partitions = Optional.empty();
    private Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer = Optional.empty();
    private Optional<Supplier<SubscriberServiceClient>> subscriberServiceClientSupplier = Optional.empty();
    private Optional<Supplier<CursorServiceClient>> cursorServiceClientSupplier = Optional.empty();
    private Optional<PartitionAssignmentServiceClient> assignmentServiceClient = Optional.empty();
    private Optional<NackHandler> nackHandler = Optional.empty();
    Builder() {
    }
    @Override
    public SubscriberSettings.Builder setReceiver(MessageReceiver receiver) {
      if (receiver == null) {
        throw new NullPointerException("Null receiver");
      }
      this.receiver = receiver;
      return this;
    }
    @Override
    public SubscriberSettings.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
      if (subscriptionPath == null) {
        throw new NullPointerException("Null subscriptionPath");
      }
      this.subscriptionPath = subscriptionPath;
      return this;
    }
    @Override
    public SubscriberSettings.Builder setPerPartitionFlowControlSettings(FlowControlSettings perPartitionFlowControlSettings) {
      if (perPartitionFlowControlSettings == null) {
        throw new NullPointerException("Null perPartitionFlowControlSettings");
      }
      this.perPartitionFlowControlSettings = perPartitionFlowControlSettings;
      return this;
    }
    @Override
    public SubscriberSettings.Builder setPartitions(List<Partition> partitions) {
      this.partitions = Optional.of(partitions);
      return this;
    }
    @Override
    public SubscriberSettings.Builder setTransformer(MessageTransformer<SequencedMessage, PubsubMessage> transformer) {
      this.transformer = Optional.of(transformer);
      return this;
    }
    @Override
    public SubscriberSettings.Builder setSubscriberServiceClientSupplier(Supplier<SubscriberServiceClient> subscriberServiceClientSupplier) {
      this.subscriberServiceClientSupplier = Optional.of(subscriberServiceClientSupplier);
      return this;
    }
    @Override
    public SubscriberSettings.Builder setCursorServiceClientSupplier(Supplier<CursorServiceClient> cursorServiceClientSupplier) {
      this.cursorServiceClientSupplier = Optional.of(cursorServiceClientSupplier);
      return this;
    }
    @Override
    public SubscriberSettings.Builder setAssignmentServiceClient(PartitionAssignmentServiceClient assignmentServiceClient) {
      this.assignmentServiceClient = Optional.of(assignmentServiceClient);
      return this;
    }
    @Override
    public SubscriberSettings.Builder setNackHandler(NackHandler nackHandler) {
      this.nackHandler = Optional.of(nackHandler);
      return this;
    }
    @Override
    SubscriberSettings autoBuild() {
      String missing = "";
      if (this.receiver == null) {
        missing += " receiver";
      }
      if (this.subscriptionPath == null) {
        missing += " subscriptionPath";
      }
      if (this.perPartitionFlowControlSettings == null) {
        missing += " perPartitionFlowControlSettings";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SubscriberSettings(
          this.receiver,
          this.subscriptionPath,
          this.perPartitionFlowControlSettings,
          this.partitions,
          this.transformer,
          this.subscriberServiceClientSupplier,
          this.cursorServiceClientSupplier,
          this.assignmentServiceClient,
          this.nackHandler);
    }
  }

}
