/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.KeyExtractor;
import com.google.cloud.pubsublite.cloudpubsub.PublisherSettings;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Optional;
import java.util.function.Supplier;

final class AutoValue_PublisherSettings
extends PublisherSettings {
    private final TopicPath topicPath;
    private final Optional<KeyExtractor> keyExtractor;
    private final Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer;
    private final Optional<BatchingSettings> batchingSettings;
    private final Optional<Supplier<PublisherServiceClient>> serviceClientSupplier;
    private final SinglePartitionPublisherBuilder.Builder underlyingBuilder;
    private final Optional<Integer> numPartitions;

    private AutoValue_PublisherSettings(TopicPath topicPath, Optional<KeyExtractor> keyExtractor, Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer, Optional<BatchingSettings> batchingSettings, Optional<Supplier<PublisherServiceClient>> serviceClientSupplier, SinglePartitionPublisherBuilder.Builder underlyingBuilder, Optional<Integer> numPartitions) {
        this.topicPath = topicPath;
        this.keyExtractor = keyExtractor;
        this.messageTransformer = messageTransformer;
        this.batchingSettings = batchingSettings;
        this.serviceClientSupplier = serviceClientSupplier;
        this.underlyingBuilder = underlyingBuilder;
        this.numPartitions = numPartitions;
    }

    @Override
    TopicPath topicPath() {
        return this.topicPath;
    }

    @Override
    Optional<KeyExtractor> keyExtractor() {
        return this.keyExtractor;
    }

    @Override
    Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer() {
        return this.messageTransformer;
    }

    @Override
    Optional<BatchingSettings> batchingSettings() {
        return this.batchingSettings;
    }

    @Override
    Optional<Supplier<PublisherServiceClient>> serviceClientSupplier() {
        return this.serviceClientSupplier;
    }

    @Override
    SinglePartitionPublisherBuilder.Builder underlyingBuilder() {
        return this.underlyingBuilder;
    }

    @Override
    Optional<Integer> numPartitions() {
        return this.numPartitions;
    }

    public String toString() {
        return "PublisherSettings{topicPath=" + this.topicPath + ", keyExtractor=" + this.keyExtractor + ", messageTransformer=" + this.messageTransformer + ", batchingSettings=" + this.batchingSettings + ", serviceClientSupplier=" + this.serviceClientSupplier + ", underlyingBuilder=" + this.underlyingBuilder + ", numPartitions=" + this.numPartitions + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PublisherSettings) {
            PublisherSettings that = (PublisherSettings)o;
            return this.topicPath.equals(that.topicPath()) && this.keyExtractor.equals(that.keyExtractor()) && this.messageTransformer.equals(that.messageTransformer()) && this.batchingSettings.equals(that.batchingSettings()) && this.serviceClientSupplier.equals(that.serviceClientSupplier()) && this.underlyingBuilder.equals(that.underlyingBuilder()) && this.numPartitions.equals(that.numPartitions());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topicPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyExtractor.hashCode();
        h$ *= 1000003;
        h$ ^= this.messageTransformer.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchingSettings.hashCode();
        h$ *= 1000003;
        h$ ^= this.serviceClientSupplier.hashCode();
        h$ *= 1000003;
        h$ ^= this.underlyingBuilder.hashCode();
        h$ *= 1000003;
        return h$ ^= this.numPartitions.hashCode();
    }

    static final class Builder
    extends PublisherSettings.Builder {
        private TopicPath topicPath;
        private Optional<KeyExtractor> keyExtractor = Optional.empty();
        private Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer = Optional.empty();
        private Optional<BatchingSettings> batchingSettings = Optional.empty();
        private Optional<Supplier<PublisherServiceClient>> serviceClientSupplier = Optional.empty();
        private SinglePartitionPublisherBuilder.Builder underlyingBuilder;
        private Optional<Integer> numPartitions = Optional.empty();

        Builder() {
        }

        @Override
        public PublisherSettings.Builder setTopicPath(TopicPath topicPath) {
            if (topicPath == null) {
                throw new NullPointerException("Null topicPath");
            }
            this.topicPath = topicPath;
            return this;
        }

        @Override
        public PublisherSettings.Builder setKeyExtractor(KeyExtractor keyExtractor) {
            this.keyExtractor = Optional.of(keyExtractor);
            return this;
        }

        @Override
        public PublisherSettings.Builder setMessageTransformer(MessageTransformer<PubsubMessage, Message> messageTransformer) {
            this.messageTransformer = Optional.of(messageTransformer);
            return this;
        }

        @Override
        public PublisherSettings.Builder setBatchingSettings(BatchingSettings batchingSettings) {
            this.batchingSettings = Optional.of(batchingSettings);
            return this;
        }

        @Override
        public PublisherSettings.Builder setServiceClientSupplier(Supplier<PublisherServiceClient> serviceClientSupplier) {
            this.serviceClientSupplier = Optional.of(serviceClientSupplier);
            return this;
        }

        @Override
        PublisherSettings.Builder setUnderlyingBuilder(SinglePartitionPublisherBuilder.Builder underlyingBuilder) {
            if (underlyingBuilder == null) {
                throw new NullPointerException("Null underlyingBuilder");
            }
            this.underlyingBuilder = underlyingBuilder;
            return this;
        }

        @Override
        PublisherSettings.Builder setNumPartitions(int numPartitions) {
            this.numPartitions = Optional.of(numPartitions);
            return this;
        }

        @Override
        public PublisherSettings build() {
            String missing = "";
            if (this.topicPath == null) {
                missing = missing + " topicPath";
            }
            if (this.underlyingBuilder == null) {
                missing = missing + " underlyingBuilder";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PublisherSettings(this.topicPath, this.keyExtractor, this.messageTransformer, this.batchingSettings, this.serviceClientSupplier, this.underlyingBuilder, this.numPartitions);
        }
    }
}

