/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PublishMetadata;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.AutoValue_SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.PublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisher;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import java.util.Optional;

@AutoValue
public abstract class SinglePartitionPublisherBuilder {
    abstract TopicPath topic();

    abstract Partition partition();

    abstract Optional<PublisherServiceClient> serviceClient();

    abstract Optional<BatchingSettings> batchingSettings();

    abstract PubsubContext context();

    abstract PublisherBuilder.Builder underlyingBuilder();

    public static Builder newBuilder() {
        return new AutoValue_SinglePartitionPublisherBuilder.Builder().setContext(PubsubContext.of()).setUnderlyingBuilder(PublisherBuilder.builder());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopic(TopicPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setServiceClient(PublisherServiceClient var1);

        public abstract Builder setBatchingSettings(BatchingSettings var1);

        public abstract Builder setContext(PubsubContext var1);

        abstract Builder setUnderlyingBuilder(PublisherBuilder.Builder var1);

        abstract SinglePartitionPublisherBuilder autoBuild();

        public Publisher<PublishMetadata> build() throws ApiException {
            SinglePartitionPublisherBuilder builder = this.autoBuild();
            PublisherBuilder.Builder publisherBuilder = builder.underlyingBuilder().setTopic(builder.topic()).setPartition(builder.partition()).setContext(builder.context());
            builder.serviceClient().ifPresent(publisherBuilder::setServiceClient);
            builder.batchingSettings().ifPresent(publisherBuilder::setBatching);
            return new SinglePartitionPublisher(publisherBuilder.build(), builder.partition());
        }
    }
}

