/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectLookupUtils;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.AutoValue_SubscriberSettings;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.cloudpubsub.MessageTransforms;
import com.google.cloud.pubsublite.cloudpubsub.NackHandler;
import com.google.cloud.pubsublite.cloudpubsub.Subscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.AckSetTrackerImpl;
import com.google.cloud.pubsublite.cloudpubsub.internal.AssigningSubscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.MultiPartitionSubscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.PartitionSubscriberFactory;
import com.google.cloud.pubsublite.cloudpubsub.internal.SinglePartitionSubscriber;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.AssignerBuilder;
import com.google.cloud.pubsublite.internal.wire.AssignerFactory;
import com.google.cloud.pubsublite.internal.wire.CommitterBuilder;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceClient;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import com.google.pubsub.v1.PubsubMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@AutoValue
public abstract class SubscriberSettings {
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of("CLOUD_PUBSUB_SHIM");

    abstract MessageReceiver receiver();

    abstract SubscriptionPath subscriptionPath();

    abstract FlowControlSettings perPartitionFlowControlSettings();

    abstract Optional<List<Partition>> partitions();

    abstract Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer();

    abstract Optional<Supplier<SubscriberServiceClient>> subscriberServiceClientSupplier();

    abstract Optional<Supplier<CursorServiceClient>> cursorServiceClientSupplier();

    abstract Optional<PartitionAssignmentServiceClient> assignmentServiceClient();

    abstract Optional<NackHandler> nackHandler();

    public static Builder newBuilder() {
        return new AutoValue_SubscriberSettings.Builder();
    }

    PartitionSubscriberFactory makePartitionSubscriberFactory(SubscriptionPath canonicalPath) throws ApiException {
        return partition -> {
            try {
                SubscriberBuilder.Builder wireSubscriberBuilder = SubscriberBuilder.newBuilder();
                wireSubscriberBuilder.setSubscriptionPath(canonicalPath);
                this.subscriberServiceClientSupplier().ifPresent(supplier -> wireSubscriberBuilder.setServiceClient((SubscriberServiceClient)supplier.get()));
                wireSubscriberBuilder.setContext(PubsubContext.of(FRAMEWORK));
                wireSubscriberBuilder.setPartition(partition);
                CommitterBuilder.Builder wireCommitterBuilder = CommitterBuilder.newBuilder();
                wireCommitterBuilder.setSubscriptionPath(canonicalPath);
                this.cursorServiceClientSupplier().ifPresent(supplier -> wireCommitterBuilder.setServiceClient((CursorServiceClient)supplier.get()));
                wireCommitterBuilder.setPartition(partition);
                return new SinglePartitionSubscriber(this.receiver(), this.transformer().orElse(MessageTransforms.toCpsSubscribeTransformer()), new AckSetTrackerImpl(wireCommitterBuilder.build()), this.nackHandler().orElse(new NackHandler(){}), messageConsumer -> wireSubscriberBuilder.setMessageConsumer(messageConsumer).build(), this.perPartitionFlowControlSettings());
            }
            catch (Throwable t) {
                throw ExtractStatus.toCanonical(t);
            }
        };
    }

    Subscriber instantiate() throws ApiException {
        SubscriptionPath canonicalPath = ProjectLookupUtils.toCanonical(this.subscriptionPath());
        PartitionSubscriberFactory partitionSubscriberFactory = this.makePartitionSubscriberFactory(canonicalPath);
        if (!this.partitions().isPresent()) {
            AssignerBuilder.Builder assignerBuilder = AssignerBuilder.newBuilder();
            assignerBuilder.setSubscriptionPath(canonicalPath);
            this.assignmentServiceClient().ifPresent(assignerBuilder::setServiceClient);
            AssignerFactory assignerFactory = receiver -> {
                assignerBuilder.setReceiver(receiver);
                return assignerBuilder.build();
            };
            return new AssigningSubscriber(partitionSubscriberFactory, assignerFactory);
        }
        ArrayList<Subscriber> perPartitionSubscribers = new ArrayList<Subscriber>();
        for (Partition partition : this.partitions().get()) {
            try {
                perPartitionSubscribers.add(partitionSubscriberFactory.newSubscriber(partition));
            }
            catch (CheckedApiException e) {
                throw e.underlying;
            }
        }
        return MultiPartitionSubscriber.of(perPartitionSubscribers);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setReceiver(MessageReceiver var1);

        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPerPartitionFlowControlSettings(FlowControlSettings var1);

        public abstract Builder setPartitions(List<Partition> var1);

        public abstract Builder setTransformer(MessageTransformer<SequencedMessage, PubsubMessage> var1);

        public abstract Builder setSubscriberServiceClientSupplier(Supplier<SubscriberServiceClient> var1);

        public abstract Builder setCursorServiceClientSupplier(Supplier<CursorServiceClient> var1);

        public abstract Builder setAssignmentServiceClient(PartitionAssignmentServiceClient var1);

        public abstract Builder setNackHandler(NackHandler var1);

        abstract SubscriberSettings autoBuild();

        public SubscriberSettings build() throws ApiException {
            SubscriberSettings settings = this.autoBuild();
            UncheckedApiPreconditions.checkArgument(!settings.partitions().isPresent() || !settings.partitions().get().isEmpty(), "Must provide at least one partition if setting partitions explicitly.");
            return settings;
        }
    }
}

