/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectLookupUtils;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

final class RoutingMetadata {
    static final String PARAMS_HEADER = "x-goog-request-params";

    private RoutingMetadata() {
    }

    static Map<String, String> of(TopicPath topic, Partition partition) throws ApiException {
        try {
            String topic_value = URLEncoder.encode(ProjectLookupUtils.toCanonical(topic).toString(), StandardCharsets.UTF_8.toString());
            String params = String.format("partition=%s&topic=%s", partition.value(), topic_value);
            return ImmutableMap.of((Object)PARAMS_HEADER, (Object)params);
        }
        catch (UnsupportedEncodingException e) {
            throw ExtractStatus.toCanonical((Throwable)e).underlying;
        }
    }

    static Map<String, String> of(SubscriptionPath subscription, Partition partition) throws ApiException {
        try {
            String subscription_value = URLEncoder.encode(ProjectLookupUtils.toCanonical(subscription).toString(), StandardCharsets.UTF_8.toString());
            String params = String.format("partition=%s&subscription=%s", partition.value(), subscription_value);
            return ImmutableMap.of((Object)PARAMS_HEADER, (Object)params);
        }
        catch (UnsupportedEncodingException e) {
            throw ExtractStatus.toCanonical((Throwable)e).underlying;
        }
    }
}

