/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.internal.AutoValue_TopicStatsClientSettings;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.ServiceClients;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.internal.TopicStatsClientImpl;
import com.google.cloud.pubsublite.v1.TopicStatsServiceClient;
import com.google.cloud.pubsublite.v1.TopicStatsServiceSettings;
import java.util.Optional;

@AutoValue
public abstract class TopicStatsClientSettings {
    abstract CloudRegion region();

    abstract Optional<TopicStatsServiceClient> serviceClient();

    public static Builder newBuilder() {
        return new AutoValue_TopicStatsClientSettings.Builder();
    }

    TopicStatsClient instantiate() throws ApiException {
        TopicStatsServiceClient serviceClient;
        if (this.serviceClient().isPresent()) {
            serviceClient = this.serviceClient().get();
        } else {
            try {
                serviceClient = TopicStatsServiceClient.create((TopicStatsServiceSettings)((Object)ServiceClients.addDefaultSettings(this.region(), TopicStatsServiceSettings.newBuilder())));
            }
            catch (Throwable t) {
                throw ExtractStatus.toCanonical((Throwable)t).underlying;
            }
        }
        return new TopicStatsClientImpl(this.region(), serviceClient);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRegion(CloudRegion var1);

        public abstract Builder setServiceClient(TopicStatsServiceClient var1);

        public abstract TopicStatsClientSettings build();
    }
}

