package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.RoutingPolicy;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PartitionCountWatchingPublisherSettings extends PartitionCountWatchingPublisherSettings {

  private final TopicPath topic;

  private final PartitionPublisherFactory publisherFactory;

  private final PartitionCountWatcher.Factory configWatcherFactory;

  private final RoutingPolicy.Factory routingPolicyFactory;

  private final Duration configPollPeriod;

  private AutoValue_PartitionCountWatchingPublisherSettings(
      TopicPath topic,
      PartitionPublisherFactory publisherFactory,
      PartitionCountWatcher.Factory configWatcherFactory,
      RoutingPolicy.Factory routingPolicyFactory,
      Duration configPollPeriod) {
    this.topic = topic;
    this.publisherFactory = publisherFactory;
    this.configWatcherFactory = configWatcherFactory;
    this.routingPolicyFactory = routingPolicyFactory;
    this.configPollPeriod = configPollPeriod;
  }

  @Override
  TopicPath topic() {
    return topic;
  }

  @Override
  PartitionPublisherFactory publisherFactory() {
    return publisherFactory;
  }

  @Override
  PartitionCountWatcher.Factory configWatcherFactory() {
    return configWatcherFactory;
  }

  @Override
  RoutingPolicy.Factory routingPolicyFactory() {
    return routingPolicyFactory;
  }

  @Override
  Duration configPollPeriod() {
    return configPollPeriod;
  }

  @Override
  public String toString() {
    return "PartitionCountWatchingPublisherSettings{"
        + "topic=" + topic + ", "
        + "publisherFactory=" + publisherFactory + ", "
        + "configWatcherFactory=" + configWatcherFactory + ", "
        + "routingPolicyFactory=" + routingPolicyFactory + ", "
        + "configPollPeriod=" + configPollPeriod
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PartitionCountWatchingPublisherSettings) {
      PartitionCountWatchingPublisherSettings that = (PartitionCountWatchingPublisherSettings) o;
      return this.topic.equals(that.topic())
          && this.publisherFactory.equals(that.publisherFactory())
          && this.configWatcherFactory.equals(that.configWatcherFactory())
          && this.routingPolicyFactory.equals(that.routingPolicyFactory())
          && this.configPollPeriod.equals(that.configPollPeriod());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topic.hashCode();
    h$ *= 1000003;
    h$ ^= publisherFactory.hashCode();
    h$ *= 1000003;
    h$ ^= configWatcherFactory.hashCode();
    h$ *= 1000003;
    h$ ^= routingPolicyFactory.hashCode();
    h$ *= 1000003;
    h$ ^= configPollPeriod.hashCode();
    return h$;
  }

  static final class Builder extends PartitionCountWatchingPublisherSettings.Builder {
    private TopicPath topic;
    private PartitionPublisherFactory publisherFactory;
    private PartitionCountWatcher.Factory configWatcherFactory;
    private RoutingPolicy.Factory routingPolicyFactory;
    private Duration configPollPeriod;
    Builder() {
    }
    @Override
    public PartitionCountWatchingPublisherSettings.Builder setTopic(TopicPath topic) {
      if (topic == null) {
        throw new NullPointerException("Null topic");
      }
      this.topic = topic;
      return this;
    }
    @Override
    TopicPath topic() {
      if (topic == null) {
        throw new IllegalStateException("Property \"topic\" has not been set");
      }
      return topic;
    }
    @Override
    public PartitionCountWatchingPublisherSettings.Builder setPublisherFactory(PartitionPublisherFactory publisherFactory) {
      if (publisherFactory == null) {
        throw new NullPointerException("Null publisherFactory");
      }
      this.publisherFactory = publisherFactory;
      return this;
    }
    @Override
    public PartitionCountWatchingPublisherSettings.Builder setConfigWatcherFactory(PartitionCountWatcher.Factory configWatcherFactory) {
      if (configWatcherFactory == null) {
        throw new NullPointerException("Null configWatcherFactory");
      }
      this.configWatcherFactory = configWatcherFactory;
      return this;
    }
    @Override
    Optional<PartitionCountWatcher.Factory> configWatcherFactory() {
      if (configWatcherFactory == null) {
        return Optional.empty();
      } else {
        return Optional.of(configWatcherFactory);
      }
    }
    @Override
    public PartitionCountWatchingPublisherSettings.Builder setRoutingPolicyFactory(RoutingPolicy.Factory routingPolicyFactory) {
      if (routingPolicyFactory == null) {
        throw new NullPointerException("Null routingPolicyFactory");
      }
      this.routingPolicyFactory = routingPolicyFactory;
      return this;
    }
    @Override
    Optional<RoutingPolicy.Factory> routingPolicyFactory() {
      if (routingPolicyFactory == null) {
        return Optional.empty();
      } else {
        return Optional.of(routingPolicyFactory);
      }
    }
    @Override
    public PartitionCountWatchingPublisherSettings.Builder setConfigPollPeriod(Duration configPollPeriod) {
      if (configPollPeriod == null) {
        throw new NullPointerException("Null configPollPeriod");
      }
      this.configPollPeriod = configPollPeriod;
      return this;
    }
    @Override
    Duration configPollPeriod() {
      if (configPollPeriod == null) {
        throw new IllegalStateException("Property \"configPollPeriod\" has not been set");
      }
      return configPollPeriod;
    }
    @Override
    PartitionCountWatchingPublisherSettings autoBuild() {
      String missing = "";
      if (this.topic == null) {
        missing += " topic";
      }
      if (this.publisherFactory == null) {
        missing += " publisherFactory";
      }
      if (this.configWatcherFactory == null) {
        missing += " configWatcherFactory";
      }
      if (this.routingPolicyFactory == null) {
        missing += " routingPolicyFactory";
      }
      if (this.configPollPeriod == null) {
        missing += " configPollPeriod";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PartitionCountWatchingPublisherSettings(
          this.topic,
          this.publisherFactory,
          this.configWatcherFactory,
          this.routingPolicyFactory,
          this.configPollPeriod);
    }
  }

}
