/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.ApiExceptionCommitter;
import com.google.cloud.pubsublite.internal.wire.AutoValue_CommitterBuilder;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.CommitterImpl;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.proto.InitialCommitCursorRequest;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.CursorServiceSettings;
import java.util.Optional;

@AutoValue
public abstract class CommitterBuilder {
    abstract SubscriptionPath subscriptionPath();

    abstract Partition partition();

    abstract Optional<CursorServiceClient> serviceClient();

    public static Builder newBuilder() {
        return new AutoValue_CommitterBuilder.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setServiceClient(CursorServiceClient var1);

        abstract CommitterBuilder autoBuild();

        public Committer build() throws ApiException {
            CursorServiceClient serviceClient;
            CommitterBuilder builder = this.autoBuild();
            if (builder.serviceClient().isPresent()) {
                serviceClient = builder.serviceClient().get();
            } else {
                try {
                    serviceClient = CursorServiceClient.create((CursorServiceSettings)((Object)ServiceClients.addDefaultSettings(builder.subscriptionPath().location().region(), CursorServiceSettings.newBuilder())));
                }
                catch (Throwable t) {
                    throw ExtractStatus.toCanonical((Throwable)t).underlying;
                }
            }
            InitialCommitCursorRequest initialCommitCursorRequest = InitialCommitCursorRequest.newBuilder().setSubscription(builder.subscriptionPath().toString()).setPartition(builder.partition().value()).build();
            return new ApiExceptionCommitter(new CommitterImpl(serviceClient, initialCommitCursorRequest));
        }
    }
}

