/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.DefaultRoutingPolicy;
import com.google.cloud.pubsublite.internal.RoutingPolicy;
import com.google.cloud.pubsublite.internal.wire.AutoValue_PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatcher;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatcherImpl;
import com.google.cloud.pubsublite.internal.wire.PartitionPublisherFactory;
import java.time.Duration;
import java.util.Optional;

@AutoValue
public abstract class PartitionCountWatchingPublisherSettings {
    abstract TopicPath topic();

    abstract PartitionPublisherFactory publisherFactory();

    abstract PartitionCountWatcher.Factory configWatcherFactory();

    abstract RoutingPolicy.Factory routingPolicyFactory();

    abstract Duration configPollPeriod();

    public static Builder newBuilder() {
        return new AutoValue_PartitionCountWatchingPublisherSettings.Builder().setConfigPollPeriod(Duration.ofMinutes(10L));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopic(TopicPath var1);

        public abstract Builder setPublisherFactory(PartitionPublisherFactory var1);

        public abstract Builder setConfigWatcherFactory(PartitionCountWatcher.Factory var1);

        public abstract Builder setRoutingPolicyFactory(RoutingPolicy.Factory var1);

        public abstract Builder setConfigPollPeriod(Duration var1);

        abstract Optional<PartitionCountWatcher.Factory> configWatcherFactory();

        abstract Optional<RoutingPolicy.Factory> routingPolicyFactory();

        abstract Duration configPollPeriod();

        abstract TopicPath topic();

        abstract PartitionCountWatchingPublisherSettings autoBuild();

        public PartitionCountWatchingPublisherSettings build() {
            if (!this.configWatcherFactory().isPresent()) {
                this.setConfigWatcherFactory(new PartitionCountWatcherImpl.Factory(this.topic(), AdminClient.create(AdminClientSettings.newBuilder().setRegion(this.topic().location().region()).build()), this.configPollPeriod()));
            }
            if (!this.routingPolicyFactory().isPresent()) {
                this.setRoutingPolicyFactory(DefaultRoutingPolicy::new);
            }
            return this.autoBuild();
        }
    }
}

