/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.AutoValue_PublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.PublisherImpl;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.proto.InitialPublishRequest;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import com.google.cloud.pubsublite.v1.PublisherServiceSettings;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.threeten.bp.Duration;

@AutoValue
public abstract class PublisherBuilder {
    public static final BatchingSettings DEFAULT_BATCHING_SETTINGS = BatchingSettings.newBuilder().setDelayThreshold(Duration.ofMillis((long)50L)).setElementCountThreshold(Long.valueOf(1000L)).setRequestByteThreshold(Long.valueOf(3500000L)).setIsEnabled(Boolean.valueOf(true)).build();
    public static final BatchingSettings DISABLED_BATCHING_SETTINGS = BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(1L)).setRequestByteThreshold(Long.valueOf(1L)).setIsEnabled(Boolean.valueOf(true)).build();

    abstract TopicPath topic();

    abstract Partition partition();

    abstract BatchingSettings batching();

    abstract Optional<PublisherServiceClient> serviceClient();

    abstract PubsubContext context();

    public static Builder builder() {
        AutoValue_PublisherBuilder.Builder impl = new AutoValue_PublisherBuilder.Builder();
        return ((Builder)impl).setBatching(DEFAULT_BATCHING_SETTINGS).setContext(PubsubContext.of());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopic(TopicPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setBatching(BatchingSettings var1);

        public abstract Builder setServiceClient(PublisherServiceClient var1);

        public abstract Builder setContext(PubsubContext var1);

        abstract PublisherBuilder autoBuild();

        public Publisher<Offset> build() throws ApiException {
            PublisherServiceClient serviceClient;
            PublisherBuilder autoBuilt = this.autoBuild();
            if (autoBuilt.serviceClient().isPresent()) {
                serviceClient = autoBuilt.serviceClient().get();
            } else {
                try {
                    PublisherServiceSettings.Builder settingsBuilder = PublisherServiceSettings.newBuilder();
                    ServiceClients.addDefaultMetadata(autoBuilt.context(), RoutingMetadata.of(autoBuilt.topic(), autoBuilt.partition()), settingsBuilder);
                    serviceClient = PublisherServiceClient.create((PublisherServiceSettings)((Object)ServiceClients.addDefaultSettings(autoBuilt.topic().location().region(), settingsBuilder)));
                }
                catch (Throwable t) {
                    throw ExtractStatus.toCanonical((Throwable)t).underlying;
                }
            }
            return new PublisherImpl(serviceClient, InitialPublishRequest.newBuilder().setTopic(autoBuilt.topic().toString()).setPartition(autoBuilt.partition().value()).build(), Builder.validateBatchingSettings(autoBuilt.batching()));
        }

        static BatchingSettings validateBatchingSettings(BatchingSettings batching) {
            Preconditions.checkArgument((boolean)batching.getFlowControlSettings().getLimitExceededBehavior().equals((Object)FlowController.LimitExceededBehavior.Ignore), (Object)"Publisher does not accept flow control settings as the behavior would be non-obvious given a Publisher implementation. Use external flow control instead.");
            if (!batching.getIsEnabled().booleanValue()) {
                return DISABLED_BATCHING_SETTINGS;
            }
            Preconditions.checkNotNull((Object)batching.getElementCountThreshold());
            Preconditions.checkNotNull((Object)batching.getRequestByteThreshold());
            Preconditions.checkArgument((batching.getElementCountThreshold() <= 1000L ? 1 : 0) != 0, (Object)"Batching element count greater than max value.");
            Preconditions.checkArgument((batching.getRequestByteThreshold() <= 3500000L ? 1 : 0) != 0, (Object)"Batching byte count greater than max value.");
            return batching;
        }
    }
}

