/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.ApiExceptionSubscriber;
import com.google.cloud.pubsublite.internal.wire.AutoValue_SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.internal.wire.SubscriberImpl;
import com.google.cloud.pubsublite.proto.InitialSubscribeRequest;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import com.google.cloud.pubsublite.v1.SubscriberServiceSettings;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.function.Consumer;

@AutoValue
public abstract class SubscriberBuilder {
    abstract Consumer<ImmutableList<SequencedMessage>> messageConsumer();

    abstract SubscriptionPath subscriptionPath();

    abstract Partition partition();

    abstract Optional<SubscriberServiceClient> serviceClient();

    abstract PubsubContext context();

    public static Builder newBuilder() {
        return new AutoValue_SubscriberBuilder.Builder().setContext(PubsubContext.of());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMessageConsumer(Consumer<ImmutableList<SequencedMessage>> var1);

        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setServiceClient(SubscriberServiceClient var1);

        public abstract Builder setContext(PubsubContext var1);

        abstract SubscriberBuilder autoBuild();

        public Subscriber build() throws ApiException {
            SubscriberServiceClient serviceClient;
            SubscriberBuilder autoBuilt = this.autoBuild();
            if (autoBuilt.serviceClient().isPresent()) {
                serviceClient = autoBuilt.serviceClient().get();
            } else {
                try {
                    SubscriberServiceSettings.Builder settingsBuilder = SubscriberServiceSettings.newBuilder();
                    ServiceClients.addDefaultMetadata(autoBuilt.context(), RoutingMetadata.of(autoBuilt.subscriptionPath(), autoBuilt.partition()), settingsBuilder);
                    serviceClient = SubscriberServiceClient.create((SubscriberServiceSettings)((Object)ServiceClients.addDefaultSettings(autoBuilt.subscriptionPath().location().region(), settingsBuilder)));
                }
                catch (Throwable t) {
                    throw ExtractStatus.toCanonical((Throwable)t).underlying;
                }
            }
            InitialSubscribeRequest initialSubscribeRequest = InitialSubscribeRequest.newBuilder().setSubscription(autoBuilt.subscriptionPath().toString()).setPartition(autoBuilt.partition().value()).build();
            return new ApiExceptionSubscriber(new SubscriberImpl(serviceClient, initialSubscribeRequest, autoBuilt.messageConsumer()));
        }
    }
}

