/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.AutoValue_PublisherSettings;
import com.google.cloud.pubsublite.cloudpubsub.KeyExtractor;
import com.google.cloud.pubsublite.cloudpubsub.MessageTransforms;
import com.google.cloud.pubsublite.cloudpubsub.Publisher;
import com.google.cloud.pubsublite.cloudpubsub.internal.WrappingPublisher;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.v1.AdminServiceClient;
import com.google.cloud.pubsublite.v1.AdminServiceSettings;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import com.google.cloud.pubsublite.v1.PublisherServiceSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Optional;
import java.util.function.Supplier;
import org.threeten.bp.Duration;

@AutoValue
public abstract class PublisherSettings {
    public static final BatchingSettings DEFAULT_BATCHING_SETTINGS = BatchingSettings.newBuilder().setIsEnabled(Boolean.valueOf(true)).setElementCountThreshold(Long.valueOf(1000L)).setRequestByteThreshold(Long.valueOf(3500000L)).setDelayThreshold(Duration.ofMillis((long)50L)).build();
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of("CLOUD_PUBSUB_SHIM");

    abstract TopicPath topicPath();

    abstract Optional<KeyExtractor> keyExtractor();

    abstract Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer();

    abstract Optional<BatchingSettings> batchingSettings();

    abstract CredentialsProvider credentialsProvider();

    abstract Optional<Supplier<PublisherServiceClient>> serviceClientSupplier();

    abstract Optional<AdminClient> adminClient();

    abstract SinglePartitionPublisherBuilder.Builder underlyingBuilder();

    public static Builder newBuilder() {
        return new AutoValue_PublisherSettings.Builder().setCredentialsProvider((CredentialsProvider)PublisherServiceSettings.defaultCredentialsProviderBuilder().build()).setUnderlyingBuilder(SinglePartitionPublisherBuilder.newBuilder());
    }

    private PublisherServiceClient newServiceClient(Partition partition) throws ApiException {
        if (this.serviceClientSupplier().isPresent()) {
            return this.serviceClientSupplier().get().get();
        }
        PublisherServiceSettings.Builder settingsBuilder = PublisherServiceSettings.newBuilder();
        settingsBuilder = (PublisherServiceSettings.Builder)settingsBuilder.setCredentialsProvider(this.credentialsProvider());
        settingsBuilder = ServiceClients.addDefaultMetadata(PubsubContext.of(FRAMEWORK), RoutingMetadata.of(this.topicPath(), partition), settingsBuilder);
        try {
            return PublisherServiceClient.create((PublisherServiceSettings)((Object)ServiceClients.addDefaultSettings(this.topicPath().location().region(), settingsBuilder)));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private AdminClient getAdminClient() throws ApiException {
        if (this.adminClient().isPresent()) {
            return this.adminClient().get();
        }
        try {
            return AdminClient.create(AdminClientSettings.newBuilder().setServiceClient(AdminServiceClient.create((AdminServiceSettings)((Object)ServiceClients.addDefaultSettings(this.topicPath().location().region(), AdminServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider()))))).setRegion(this.topicPath().location().region()).build());
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    Publisher instantiate() throws ApiException {
        BatchingSettings batchingSettings = this.batchingSettings().orElse(DEFAULT_BATCHING_SETTINGS);
        KeyExtractor keyExtractor = this.keyExtractor().orElse(KeyExtractor.DEFAULT);
        MessageTransformer messageTransformer = this.messageTransformer().orElseGet(() -> MessageTransforms.fromCpsPublishTransformer(keyExtractor));
        PartitionCountWatchingPublisherSettings.Builder publisherSettings = PartitionCountWatchingPublisherSettings.newBuilder().setTopic(this.topicPath()).setPublisherFactory(partition -> {
            SinglePartitionPublisherBuilder.Builder singlePartitionBuilder = this.underlyingBuilder().setBatchingSettings(batchingSettings).setTopic(this.topicPath()).setPartition(partition).setServiceClient(this.newServiceClient(partition));
            return singlePartitionBuilder.build();
        }).setAdminClient(this.getAdminClient());
        return new WrappingPublisher(publisherSettings.build().instantiate(), messageTransformer);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopicPath(TopicPath var1);

        public abstract Builder setKeyExtractor(KeyExtractor var1);

        public abstract Builder setMessageTransformer(MessageTransformer<PubsubMessage, Message> var1);

        public abstract Builder setBatchingSettings(BatchingSettings var1);

        public abstract Builder setCredentialsProvider(CredentialsProvider var1);

        public abstract Builder setServiceClientSupplier(Supplier<PublisherServiceClient> var1);

        public abstract Builder setAdminClient(AdminClient var1);

        @VisibleForTesting
        abstract Builder setUnderlyingBuilder(SinglePartitionPublisherBuilder.Builder var1);

        public abstract PublisherSettings build();
    }
}

