/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsublite.proto.ComputeHeadCursorRequest;
import com.google.cloud.pubsublite.proto.ComputeHeadCursorResponse;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import com.google.cloud.pubsublite.v1.stub.GrpcTopicStatsServiceCallableFactory;
import com.google.cloud.pubsublite.v1.stub.TopicStatsServiceStub;
import com.google.cloud.pubsublite.v1.stub.TopicStatsServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcTopicStatsServiceStub
extends TopicStatsServiceStub {
    private static final MethodDescriptor<ComputeMessageStatsRequest, ComputeMessageStatsResponse> computeMessageStatsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.TopicStatsService/ComputeMessageStats").setRequestMarshaller(ProtoUtils.marshaller((Message)ComputeMessageStatsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ComputeMessageStatsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ComputeHeadCursorRequest, ComputeHeadCursorResponse> computeHeadCursorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.TopicStatsService/ComputeHeadCursor").setRequestMarshaller(ProtoUtils.marshaller((Message)ComputeHeadCursorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ComputeHeadCursorResponse.getDefaultInstance())).build();
    private final UnaryCallable<ComputeMessageStatsRequest, ComputeMessageStatsResponse> computeMessageStatsCallable;
    private final UnaryCallable<ComputeHeadCursorRequest, ComputeHeadCursorResponse> computeHeadCursorCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTopicStatsServiceStub create(TopicStatsServiceStubSettings settings) throws IOException {
        return new GrpcTopicStatsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTopicStatsServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcTopicStatsServiceStub(TopicStatsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTopicStatsServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTopicStatsServiceStub(TopicStatsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTopicStatsServiceStub(TopicStatsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTopicStatsServiceCallableFactory());
    }

    protected GrpcTopicStatsServiceStub(TopicStatsServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings computeMessageStatsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(computeMessageStatsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ComputeMessageStatsRequest>(){

            public Map<String, String> extract(ComputeMessageStatsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"topic", (Object)String.valueOf(request.getTopic()));
                return params.build();
            }
        }).build();
        GrpcCallSettings computeHeadCursorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(computeHeadCursorMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ComputeHeadCursorRequest>(){

            public Map<String, String> extract(ComputeHeadCursorRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"topic", (Object)String.valueOf(request.getTopic()));
                return params.build();
            }
        }).build();
        this.computeMessageStatsCallable = callableFactory.createUnaryCallable(computeMessageStatsTransportSettings, settings.computeMessageStatsSettings(), clientContext);
        this.computeHeadCursorCallable = callableFactory.createUnaryCallable(computeHeadCursorTransportSettings, settings.computeHeadCursorSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ComputeMessageStatsRequest, ComputeMessageStatsResponse> computeMessageStatsCallable() {
        return this.computeMessageStatsCallable;
    }

    @Override
    public UnaryCallable<ComputeHeadCursorRequest, ComputeHeadCursorResponse> computeHeadCursorCallable() {
        return this.computeHeadCursorCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

