/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AutoValue_AdminClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Constants;
import com.google.cloud.pubsublite.internal.AdminClientImpl;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.v1.AdminServiceClient;
import com.google.cloud.pubsublite.v1.AdminServiceSettings;
import java.util.Optional;

@AutoValue
public abstract class AdminClientSettings {
    abstract CloudRegion region();

    abstract Optional<RetrySettings> retrySettings();

    abstract Optional<AdminServiceClient> serviceClient();

    public static Builder newBuilder() {
        return new AutoValue_AdminClientSettings.Builder().setRetrySettings(Constants.DEFAULT_RETRY_SETTINGS);
    }

    AdminClient instantiate() throws ApiException {
        AdminServiceClient serviceClient;
        if (this.serviceClient().isPresent()) {
            serviceClient = this.serviceClient().get();
        } else {
            try {
                AdminServiceSettings.Builder builder = ((AdminServiceSettings)((Object)ServiceClients.addDefaultSettings(this.region(), AdminServiceSettings.newBuilder()))).toBuilder();
                if (this.retrySettings().isPresent()) {
                    builder.applyToAllUnaryMethods(callBuilder -> {
                        callBuilder.setRetrySettings(this.retrySettings().get());
                        return null;
                    });
                }
                serviceClient = AdminServiceClient.create(builder.build());
            }
            catch (Throwable t) {
                throw ExtractStatus.toCanonical((Throwable)t).underlying;
            }
        }
        return new AdminClientImpl(this.region(), serviceClient);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRegion(CloudRegion var1);

        public abstract Builder setRetrySettings(RetrySettings var1);

        public abstract Builder setServiceClient(AdminServiceClient var1);

        public abstract AdminClientSettings build();
    }
}

