/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Endpoints;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Lazy;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.ScheduledExecutorService;
import org.threeten.bp.Duration;

public final class ServiceClients {
    private static final Lazy<ExecutorProvider> PROVIDER = new Lazy<ExecutorProvider>(() -> FixedExecutorProvider.create((ScheduledExecutorService)SystemExecutors.newDaemonExecutor("pubsub-lite-service-clients")));

    private ServiceClients() {
    }

    public static <Settings extends ClientSettings<Settings>, Builder extends ClientSettings.Builder<Settings, Builder>> Settings addDefaultSettings(CloudRegion target, Builder builder) throws ApiException {
        try {
            return (Settings)builder.setEndpoint(Endpoints.regionalEndpoint(target)).setExecutorProvider(PROVIDER.get()).setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE)).setKeepAliveTime(Duration.ofMinutes((long)1L)).setKeepAliveWithoutCalls(Boolean.valueOf(true)).setKeepAliveTimeout(Duration.ofMinutes((long)1L)).build()).build();
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    public static <Settings extends ClientSettings<Settings>, Builder extends ClientSettings.Builder<Settings, Builder>> Builder addDefaultMetadata(PubsubContext context, RoutingMetadata routingMetadata, Builder builder) {
        return (Builder)builder.setHeaderProvider(() -> ImmutableMap.builder().putAll(context.getMetadata()).putAll(routingMetadata.getMetadata()).build());
    }
}

