/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiService;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;

public class ApiServiceUtils {
    private static final GoogleLogger LOGGER = GoogleLogger.forEnclosingClass();

    private ApiServiceUtils() {
    }

    public static ApiService backgroundResourceAsApiService(final BackgroundResource resource) {
        return new AbstractApiService(){

            protected void doStart() {
                this.notifyStarted();
            }

            protected void doStop() {
                try {
                    resource.close();
                    this.notifyStopped();
                }
                catch (Exception e) {
                    this.notifyFailed(ExtractStatus.toCanonical(e));
                }
            }
        };
    }

    public static void stopAsync(Iterable<? extends ApiService> services) throws ApiException {
        CheckedApiException lastException = null;
        for (ApiService apiService : services) {
            try {
                apiService.stopAsync();
            }
            catch (Throwable t) {
                ((GoogleLogger.Api)((GoogleLogger.Api)LOGGER.atFine()).withCause(t)).log("Exception in service shutdown.");
                lastException = ExtractStatus.toCanonical(t);
            }
        }
        if (lastException != null) {
            throw lastException.underlying;
        }
    }

    public static void blockingShutdown(Iterable<? extends ApiService> services) throws ApiException {
        CheckedApiException lastException = null;
        for (ApiService apiService : services) {
            try {
                apiService.stopAsync();
                apiService.awaitTerminated();
            }
            catch (Throwable t) {
                ((GoogleLogger.Api)((GoogleLogger.Api)LOGGER.atFine()).withCause(t)).log("Exception in service shutdown.");
                lastException = ExtractStatus.toCanonical(t);
            }
        }
        if (lastException != null) {
            throw lastException.underlying;
        }
    }

    public static void blockingShutdown(ApiService service) {
        ApiServiceUtils.blockingShutdown((Iterable<? extends ApiService>)ImmutableList.of((Object)service));
    }
}

