package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SubscriberBuilder extends SubscriberBuilder {

  private final Consumer<List<SequencedMessage>> messageConsumer;

  private final SubscriptionPath subscriptionPath;

  private final Partition partition;

  private final StreamFactories.SubscribeStreamFactory streamFactory;

  private final SeekRequest initialLocation;

  private final SubscriberResetHandler resetHandler;

  private final boolean retryStreamRaces;

  private AutoValue_SubscriberBuilder(
      Consumer<List<SequencedMessage>> messageConsumer,
      SubscriptionPath subscriptionPath,
      Partition partition,
      StreamFactories.SubscribeStreamFactory streamFactory,
      SeekRequest initialLocation,
      SubscriberResetHandler resetHandler,
      boolean retryStreamRaces) {
    this.messageConsumer = messageConsumer;
    this.subscriptionPath = subscriptionPath;
    this.partition = partition;
    this.streamFactory = streamFactory;
    this.initialLocation = initialLocation;
    this.resetHandler = resetHandler;
    this.retryStreamRaces = retryStreamRaces;
  }

  @Override
  Consumer<List<SequencedMessage>> messageConsumer() {
    return messageConsumer;
  }

  @Override
  SubscriptionPath subscriptionPath() {
    return subscriptionPath;
  }

  @Override
  Partition partition() {
    return partition;
  }

  @Override
  StreamFactories.SubscribeStreamFactory streamFactory() {
    return streamFactory;
  }

  @Override
  SeekRequest initialLocation() {
    return initialLocation;
  }

  @Override
  SubscriberResetHandler resetHandler() {
    return resetHandler;
  }

  @Override
  boolean retryStreamRaces() {
    return retryStreamRaces;
  }

  @Override
  public String toString() {
    return "SubscriberBuilder{"
        + "messageConsumer=" + messageConsumer + ", "
        + "subscriptionPath=" + subscriptionPath + ", "
        + "partition=" + partition + ", "
        + "streamFactory=" + streamFactory + ", "
        + "initialLocation=" + initialLocation + ", "
        + "resetHandler=" + resetHandler + ", "
        + "retryStreamRaces=" + retryStreamRaces
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SubscriberBuilder) {
      SubscriberBuilder that = (SubscriberBuilder) o;
      return this.messageConsumer.equals(that.messageConsumer())
          && this.subscriptionPath.equals(that.subscriptionPath())
          && this.partition.equals(that.partition())
          && this.streamFactory.equals(that.streamFactory())
          && this.initialLocation.equals(that.initialLocation())
          && this.resetHandler.equals(that.resetHandler())
          && this.retryStreamRaces == that.retryStreamRaces();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= messageConsumer.hashCode();
    h$ *= 1000003;
    h$ ^= subscriptionPath.hashCode();
    h$ *= 1000003;
    h$ ^= partition.hashCode();
    h$ *= 1000003;
    h$ ^= streamFactory.hashCode();
    h$ *= 1000003;
    h$ ^= initialLocation.hashCode();
    h$ *= 1000003;
    h$ ^= resetHandler.hashCode();
    h$ *= 1000003;
    h$ ^= retryStreamRaces ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends SubscriberBuilder.Builder {
    private Consumer<List<SequencedMessage>> messageConsumer;
    private SubscriptionPath subscriptionPath;
    private Partition partition;
    private StreamFactories.SubscribeStreamFactory streamFactory;
    private SeekRequest initialLocation;
    private SubscriberResetHandler resetHandler;
    private boolean retryStreamRaces;
    private byte set$0;
    Builder() {
    }
    @Override
    public SubscriberBuilder.Builder setMessageConsumer(Consumer<List<SequencedMessage>> messageConsumer) {
      if (messageConsumer == null) {
        throw new NullPointerException("Null messageConsumer");
      }
      this.messageConsumer = messageConsumer;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
      if (subscriptionPath == null) {
        throw new NullPointerException("Null subscriptionPath");
      }
      this.subscriptionPath = subscriptionPath;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setPartition(Partition partition) {
      if (partition == null) {
        throw new NullPointerException("Null partition");
      }
      this.partition = partition;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setStreamFactory(StreamFactories.SubscribeStreamFactory streamFactory) {
      if (streamFactory == null) {
        throw new NullPointerException("Null streamFactory");
      }
      this.streamFactory = streamFactory;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setInitialLocation(SeekRequest initialLocation) {
      if (initialLocation == null) {
        throw new NullPointerException("Null initialLocation");
      }
      this.initialLocation = initialLocation;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setResetHandler(SubscriberResetHandler resetHandler) {
      if (resetHandler == null) {
        throw new NullPointerException("Null resetHandler");
      }
      this.resetHandler = resetHandler;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setRetryStreamRaces(boolean retryStreamRaces) {
      this.retryStreamRaces = retryStreamRaces;
      set$0 |= 1;
      return this;
    }
    @Override
    SubscriberBuilder autoBuild() {
      if (set$0 != 1
          || this.messageConsumer == null
          || this.subscriptionPath == null
          || this.partition == null
          || this.streamFactory == null
          || this.initialLocation == null
          || this.resetHandler == null) {
        StringBuilder missing = new StringBuilder();
        if (this.messageConsumer == null) {
          missing.append(" messageConsumer");
        }
        if (this.subscriptionPath == null) {
          missing.append(" subscriptionPath");
        }
        if (this.partition == null) {
          missing.append(" partition");
        }
        if (this.streamFactory == null) {
          missing.append(" streamFactory");
        }
        if (this.initialLocation == null) {
          missing.append(" initialLocation");
        }
        if (this.resetHandler == null) {
          missing.append(" resetHandler");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" retryStreamRaces");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SubscriberBuilder(
          this.messageConsumer,
          this.subscriptionPath,
          this.partition,
          this.streamFactory,
          this.initialLocation,
          this.resetHandler,
          this.retryStreamRaces);
    }
  }

}
