package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.TopicPath;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RoutingPublisherBuilder extends RoutingPublisherBuilder {

  private final TopicPath topic;

  private final PartitionPublisherFactory publisherFactory;

  private final Optional<Integer> numPartitions;

  private AutoValue_RoutingPublisherBuilder(
      TopicPath topic,
      PartitionPublisherFactory publisherFactory,
      Optional<Integer> numPartitions) {
    this.topic = topic;
    this.publisherFactory = publisherFactory;
    this.numPartitions = numPartitions;
  }

  @Override
  TopicPath topic() {
    return topic;
  }

  @Override
  PartitionPublisherFactory publisherFactory() {
    return publisherFactory;
  }

  @Override
  Optional<Integer> numPartitions() {
    return numPartitions;
  }

  @Override
  public String toString() {
    return "RoutingPublisherBuilder{"
        + "topic=" + topic + ", "
        + "publisherFactory=" + publisherFactory + ", "
        + "numPartitions=" + numPartitions
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RoutingPublisherBuilder) {
      RoutingPublisherBuilder that = (RoutingPublisherBuilder) o;
      return this.topic.equals(that.topic())
          && this.publisherFactory.equals(that.publisherFactory())
          && this.numPartitions.equals(that.numPartitions());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topic.hashCode();
    h$ *= 1000003;
    h$ ^= publisherFactory.hashCode();
    h$ *= 1000003;
    h$ ^= numPartitions.hashCode();
    return h$;
  }

  static final class Builder extends RoutingPublisherBuilder.Builder {
    private TopicPath topic;
    private PartitionPublisherFactory publisherFactory;
    private Optional<Integer> numPartitions = Optional.empty();
    Builder() {
    }
    @Override
    public RoutingPublisherBuilder.Builder setTopic(TopicPath topic) {
      if (topic == null) {
        throw new NullPointerException("Null topic");
      }
      this.topic = topic;
      return this;
    }
    @Override
    public RoutingPublisherBuilder.Builder setPublisherFactory(PartitionPublisherFactory publisherFactory) {
      if (publisherFactory == null) {
        throw new NullPointerException("Null publisherFactory");
      }
      this.publisherFactory = publisherFactory;
      return this;
    }
    @Override
    public RoutingPublisherBuilder.Builder setNumPartitions(Integer numPartitions) {
      this.numPartitions = Optional.of(numPartitions);
      return this;
    }
    @Override
    RoutingPublisherBuilder autoBuild() {
      if (this.topic == null
          || this.publisherFactory == null) {
        StringBuilder missing = new StringBuilder();
        if (this.topic == null) {
          missing.append(" topic");
        }
        if (this.publisherFactory == null) {
          missing.append(" publisherFactory");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_RoutingPublisherBuilder(
          this.topic,
          this.publisherFactory,
          this.numPartitions);
    }
  }

}
