package com.google.cloud.pubsublite.cloudpubsub;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PublisherSettings extends PublisherSettings {

  private final TopicPath topicPath;

  private final Optional<KeyExtractor> keyExtractor;

  private final Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer;

  private final BatchingSettings batchingSettings;

  private final boolean enableIdempotence;

  private final boolean enableCompression;

  private final CredentialsProvider credentialsProvider;

  private final PubsubContext.Framework framework;

  private final Optional<PublisherServiceClient> serviceClient;

  private final Optional<AdminClient> adminClient;

  private final SinglePartitionPublisherBuilder.Builder underlyingBuilder;

  private AutoValue_PublisherSettings(
      TopicPath topicPath,
      Optional<KeyExtractor> keyExtractor,
      Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer,
      BatchingSettings batchingSettings,
      boolean enableIdempotence,
      boolean enableCompression,
      CredentialsProvider credentialsProvider,
      PubsubContext.Framework framework,
      Optional<PublisherServiceClient> serviceClient,
      Optional<AdminClient> adminClient,
      SinglePartitionPublisherBuilder.Builder underlyingBuilder) {
    this.topicPath = topicPath;
    this.keyExtractor = keyExtractor;
    this.messageTransformer = messageTransformer;
    this.batchingSettings = batchingSettings;
    this.enableIdempotence = enableIdempotence;
    this.enableCompression = enableCompression;
    this.credentialsProvider = credentialsProvider;
    this.framework = framework;
    this.serviceClient = serviceClient;
    this.adminClient = adminClient;
    this.underlyingBuilder = underlyingBuilder;
  }

  @Override
  TopicPath topicPath() {
    return topicPath;
  }

  @Override
  Optional<KeyExtractor> keyExtractor() {
    return keyExtractor;
  }

  @Override
  Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer() {
    return messageTransformer;
  }

  @Override
  BatchingSettings batchingSettings() {
    return batchingSettings;
  }

  @Override
  boolean enableIdempotence() {
    return enableIdempotence;
  }

  @Override
  boolean enableCompression() {
    return enableCompression;
  }

  @Override
  CredentialsProvider credentialsProvider() {
    return credentialsProvider;
  }

  @Override
  PubsubContext.Framework framework() {
    return framework;
  }

  @Override
  Optional<PublisherServiceClient> serviceClient() {
    return serviceClient;
  }

  @Override
  Optional<AdminClient> adminClient() {
    return adminClient;
  }

  @Override
  SinglePartitionPublisherBuilder.Builder underlyingBuilder() {
    return underlyingBuilder;
  }

  @Override
  public String toString() {
    return "PublisherSettings{"
        + "topicPath=" + topicPath + ", "
        + "keyExtractor=" + keyExtractor + ", "
        + "messageTransformer=" + messageTransformer + ", "
        + "batchingSettings=" + batchingSettings + ", "
        + "enableIdempotence=" + enableIdempotence + ", "
        + "enableCompression=" + enableCompression + ", "
        + "credentialsProvider=" + credentialsProvider + ", "
        + "framework=" + framework + ", "
        + "serviceClient=" + serviceClient + ", "
        + "adminClient=" + adminClient + ", "
        + "underlyingBuilder=" + underlyingBuilder
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PublisherSettings) {
      PublisherSettings that = (PublisherSettings) o;
      return this.topicPath.equals(that.topicPath())
          && this.keyExtractor.equals(that.keyExtractor())
          && this.messageTransformer.equals(that.messageTransformer())
          && this.batchingSettings.equals(that.batchingSettings())
          && this.enableIdempotence == that.enableIdempotence()
          && this.enableCompression == that.enableCompression()
          && this.credentialsProvider.equals(that.credentialsProvider())
          && this.framework.equals(that.framework())
          && this.serviceClient.equals(that.serviceClient())
          && this.adminClient.equals(that.adminClient())
          && this.underlyingBuilder.equals(that.underlyingBuilder());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topicPath.hashCode();
    h$ *= 1000003;
    h$ ^= keyExtractor.hashCode();
    h$ *= 1000003;
    h$ ^= messageTransformer.hashCode();
    h$ *= 1000003;
    h$ ^= batchingSettings.hashCode();
    h$ *= 1000003;
    h$ ^= enableIdempotence ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= enableCompression ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= credentialsProvider.hashCode();
    h$ *= 1000003;
    h$ ^= framework.hashCode();
    h$ *= 1000003;
    h$ ^= serviceClient.hashCode();
    h$ *= 1000003;
    h$ ^= adminClient.hashCode();
    h$ *= 1000003;
    h$ ^= underlyingBuilder.hashCode();
    return h$;
  }

  static final class Builder extends PublisherSettings.Builder {
    private TopicPath topicPath;
    private Optional<KeyExtractor> keyExtractor = Optional.empty();
    private Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer = Optional.empty();
    private BatchingSettings batchingSettings;
    private boolean enableIdempotence;
    private boolean enableCompression;
    private CredentialsProvider credentialsProvider;
    private PubsubContext.Framework framework;
    private Optional<PublisherServiceClient> serviceClient = Optional.empty();
    private Optional<AdminClient> adminClient = Optional.empty();
    private SinglePartitionPublisherBuilder.Builder underlyingBuilder;
    private byte set$0;
    Builder() {
    }
    @Override
    public PublisherSettings.Builder setTopicPath(TopicPath topicPath) {
      if (topicPath == null) {
        throw new NullPointerException("Null topicPath");
      }
      this.topicPath = topicPath;
      return this;
    }
    @Override
    public PublisherSettings.Builder setKeyExtractor(KeyExtractor keyExtractor) {
      this.keyExtractor = Optional.of(keyExtractor);
      return this;
    }
    @Override
    public PublisherSettings.Builder setMessageTransformer(MessageTransformer<PubsubMessage, Message> messageTransformer) {
      this.messageTransformer = Optional.of(messageTransformer);
      return this;
    }
    @Override
    public PublisherSettings.Builder setBatchingSettings(BatchingSettings batchingSettings) {
      if (batchingSettings == null) {
        throw new NullPointerException("Null batchingSettings");
      }
      this.batchingSettings = batchingSettings;
      return this;
    }
    @Override
    public PublisherSettings.Builder setEnableIdempotence(boolean enableIdempotence) {
      this.enableIdempotence = enableIdempotence;
      set$0 |= 1;
      return this;
    }
    @Override
    public PublisherSettings.Builder setEnableCompression(boolean enableCompression) {
      this.enableCompression = enableCompression;
      set$0 |= 2;
      return this;
    }
    @Override
    public PublisherSettings.Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
      if (credentialsProvider == null) {
        throw new NullPointerException("Null credentialsProvider");
      }
      this.credentialsProvider = credentialsProvider;
      return this;
    }
    @Override
    public PublisherSettings.Builder setFramework(PubsubContext.Framework framework) {
      if (framework == null) {
        throw new NullPointerException("Null framework");
      }
      this.framework = framework;
      return this;
    }
    @Override
    public PublisherSettings.Builder setServiceClient(PublisherServiceClient serviceClient) {
      this.serviceClient = Optional.of(serviceClient);
      return this;
    }
    @Override
    public PublisherSettings.Builder setAdminClient(AdminClient adminClient) {
      this.adminClient = Optional.of(adminClient);
      return this;
    }
    @Override
    PublisherSettings.Builder setUnderlyingBuilder(SinglePartitionPublisherBuilder.Builder underlyingBuilder) {
      if (underlyingBuilder == null) {
        throw new NullPointerException("Null underlyingBuilder");
      }
      this.underlyingBuilder = underlyingBuilder;
      return this;
    }
    @Override
    public PublisherSettings build() {
      if (set$0 != 3
          || this.topicPath == null
          || this.batchingSettings == null
          || this.credentialsProvider == null
          || this.framework == null
          || this.underlyingBuilder == null) {
        StringBuilder missing = new StringBuilder();
        if (this.topicPath == null) {
          missing.append(" topicPath");
        }
        if (this.batchingSettings == null) {
          missing.append(" batchingSettings");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" enableIdempotence");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" enableCompression");
        }
        if (this.credentialsProvider == null) {
          missing.append(" credentialsProvider");
        }
        if (this.framework == null) {
          missing.append(" framework");
        }
        if (this.underlyingBuilder == null) {
          missing.append(" underlyingBuilder");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PublisherSettings(
          this.topicPath,
          this.keyExtractor,
          this.messageTransformer,
          this.batchingSettings,
          this.enableIdempotence,
          this.enableCompression,
          this.credentialsProvider,
          this.framework,
          this.serviceClient,
          this.adminClient,
          this.underlyingBuilder);
    }
  }

}
