/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.internal.wire.AutoValue_PubsubContext;
import com.google.cloud.pubsublite.internal.wire.AutoValue_PubsubContext_Framework;
import com.google.cloud.pubsublite.internal.wire.Versions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.Struct;
import com.google.protobuf.util.Values;
import java.util.Map;
import java.util.Optional;

@AutoValue
public abstract class PubsubContext {
    static final String HEADER_NAME = "x-goog-pubsub-context";
    static final String LANGUAGE_KEY = "language";
    static final String FRAMEWORK_KEY = "framework";
    static final String MAJOR_VERSION_KEY = "major_version";
    static final String MINOR_VERSION_KEY = "minor_version";
    static final String LANGUAGE_VALUE = "JAVA";

    public abstract Optional<Framework> framework();

    public static PubsubContext of(Framework framework) {
        return new AutoValue_PubsubContext(Optional.of(framework));
    }

    public static PubsubContext of() {
        return new AutoValue_PubsubContext(Optional.empty());
    }

    Struct getStruct() {
        Struct.Builder builder = Struct.newBuilder();
        builder.putFields(LANGUAGE_KEY, Values.of((String)LANGUAGE_VALUE));
        builder.putFields(MAJOR_VERSION_KEY, Values.of((double)Versions.MAJOR_VERSION));
        builder.putFields(MINOR_VERSION_KEY, Values.of((double)Versions.MINOR_VERSION));
        this.framework().ifPresent(framework -> builder.putFields(FRAMEWORK_KEY, Values.of((String)framework.value())));
        return builder.build();
    }

    Map<String, String> getMetadata() {
        return ImmutableMap.of((Object)HEADER_NAME, (Object)BaseEncoding.base64().encode(this.getStruct().toByteArray()));
    }

    @AutoValue
    public static abstract class Framework {
        public abstract String value();

        public static Framework of(String value) {
            return new AutoValue_PubsubContext_Framework(value);
        }
    }
}

