/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsublite.proto.CommitCursorRequest;
import com.google.cloud.pubsublite.proto.CommitCursorResponse;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsRequest;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsResponse;
import com.google.cloud.pubsublite.proto.PartitionCursor;
import com.google.cloud.pubsublite.proto.StreamingCommitCursorRequest;
import com.google.cloud.pubsublite.proto.StreamingCommitCursorResponse;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.stub.CursorServiceStub;
import com.google.cloud.pubsublite.v1.stub.GrpcCursorServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CursorServiceStubSettings
extends StubSettings<CursorServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final StreamingCallSettings<StreamingCommitCursorRequest, StreamingCommitCursorResponse> streamingCommitCursorSettings;
    private final UnaryCallSettings<CommitCursorRequest, CommitCursorResponse> commitCursorSettings;
    private final PagedCallSettings<ListPartitionCursorsRequest, ListPartitionCursorsResponse, CursorServiceClient.ListPartitionCursorsPagedResponse> listPartitionCursorsSettings;
    private static final PagedListDescriptor<ListPartitionCursorsRequest, ListPartitionCursorsResponse, PartitionCursor> LIST_PARTITION_CURSORS_PAGE_STR_DESC = new PagedListDescriptor<ListPartitionCursorsRequest, ListPartitionCursorsResponse, PartitionCursor>(){

        public String emptyToken() {
            return "";
        }

        public ListPartitionCursorsRequest injectToken(ListPartitionCursorsRequest payload, String token) {
            return ListPartitionCursorsRequest.newBuilder((ListPartitionCursorsRequest)payload).setPageToken(token).build();
        }

        public ListPartitionCursorsRequest injectPageSize(ListPartitionCursorsRequest payload, int pageSize) {
            return ListPartitionCursorsRequest.newBuilder((ListPartitionCursorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPartitionCursorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPartitionCursorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PartitionCursor> extractResources(ListPartitionCursorsResponse payload) {
            return payload.getPartitionCursorsList() == null ? ImmutableList.of() : payload.getPartitionCursorsList();
        }
    };
    private static final PagedListResponseFactory<ListPartitionCursorsRequest, ListPartitionCursorsResponse, CursorServiceClient.ListPartitionCursorsPagedResponse> LIST_PARTITION_CURSORS_PAGE_STR_FACT = new PagedListResponseFactory<ListPartitionCursorsRequest, ListPartitionCursorsResponse, CursorServiceClient.ListPartitionCursorsPagedResponse>(){

        public ApiFuture<CursorServiceClient.ListPartitionCursorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPartitionCursorsRequest, ListPartitionCursorsResponse> callable, ListPartitionCursorsRequest request, ApiCallContext context, ApiFuture<ListPartitionCursorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PARTITION_CURSORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CursorServiceClient.ListPartitionCursorsPagedResponse.createAsync((PageContext<ListPartitionCursorsRequest, ListPartitionCursorsResponse, PartitionCursor>)pageContext, futureResponse);
        }
    };

    public StreamingCallSettings<StreamingCommitCursorRequest, StreamingCommitCursorResponse> streamingCommitCursorSettings() {
        return this.streamingCommitCursorSettings;
    }

    public UnaryCallSettings<CommitCursorRequest, CommitCursorResponse> commitCursorSettings() {
        return this.commitCursorSettings;
    }

    public PagedCallSettings<ListPartitionCursorsRequest, ListPartitionCursorsResponse, CursorServiceClient.ListPartitionCursorsPagedResponse> listPartitionCursorsSettings() {
        return this.listPartitionCursorsSettings;
    }

    public CursorServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCursorServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "pubsublite.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "pubsublite.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CursorServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CursorServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CursorServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.streamingCommitCursorSettings = settingsBuilder.streamingCommitCursorSettings().build();
        this.commitCursorSettings = settingsBuilder.commitCursorSettings().build();
        this.listPartitionCursorsSettings = settingsBuilder.listPartitionCursorsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CursorServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final StreamingCallSettings.Builder<StreamingCommitCursorRequest, StreamingCommitCursorResponse> streamingCommitCursorSettings;
        private final UnaryCallSettings.Builder<CommitCursorRequest, CommitCursorResponse> commitCursorSettings;
        private final PagedCallSettings.Builder<ListPartitionCursorsRequest, ListPartitionCursorsResponse, CursorServiceClient.ListPartitionCursorsPagedResponse> listPartitionCursorsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.streamingCommitCursorSettings = StreamingCallSettings.newBuilder();
            this.commitCursorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPartitionCursorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PARTITION_CURSORS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.commitCursorSettings, this.listPartitionCursorsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CursorServiceStubSettings settings) {
            super((StubSettings)settings);
            this.streamingCommitCursorSettings = settings.streamingCommitCursorSettings.toBuilder();
            this.commitCursorSettings = settings.commitCursorSettings.toBuilder();
            this.listPartitionCursorsSettings = settings.listPartitionCursorsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.commitCursorSettings, this.listPartitionCursorsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CursorServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CursorServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CursorServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CursorServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CursorServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.commitCursorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPartitionCursorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public StreamingCallSettings.Builder<StreamingCommitCursorRequest, StreamingCommitCursorResponse> streamingCommitCursorSettings() {
            return this.streamingCommitCursorSettings;
        }

        public UnaryCallSettings.Builder<CommitCursorRequest, CommitCursorResponse> commitCursorSettings() {
            return this.commitCursorSettings;
        }

        public PagedCallSettings.Builder<ListPartitionCursorsRequest, ListPartitionCursorsResponse, CursorServiceClient.ListPartitionCursorsPagedResponse> listPartitionCursorsSettings() {
            return this.listPartitionCursorsSettings;
        }

        public CursorServiceStubSettings build() throws IOException {
            return new CursorServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.ABORTED, StatusCode.Code.INTERNAL, StatusCode.Code.UNKNOWN})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

